/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.models.result;

import com.google.common.base.Preconditions;
import com.mnubo.java.sdk.client.models.result.Row;
import com.mnubo.java.sdk.client.utils.Convert;
import java.util.List;

public interface ResultSet
extends Iterable<Row> {
    public List<ColumnDefinition> getColumnDefinitions();

    public boolean isExhausted();

    public Row one();

    public List<Row> all();

    public static class ColumnDefinition {
        private final String label;
        private final String highLevelType;
        private final String primitiveType;

        public ColumnDefinition(String label, String highLevelType) {
            Preconditions.checkNotNull((Object)label, (Object)"label must not be null");
            Preconditions.checkNotNull((Object)highLevelType, (Object)"label must not be null");
            this.label = label;
            this.highLevelType = highLevelType;
            this.primitiveType = Convert.highLevelToPrimitiveType(highLevelType);
        }

        public String getLabel() {
            return this.label;
        }

        public String getHighLevelType() {
            return this.highLevelType;
        }

        public String getPrimitiveType() {
            return this.primitiveType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnDefinition that = (ColumnDefinition)o;
            if (!this.label.equals(that.label)) {
                return false;
            }
            if (!this.highLevelType.equals(that.highLevelType)) {
                return false;
            }
            return this.primitiveType.equals(that.primitiveType);
        }

        public int hashCode() {
            int result = this.label.hashCode();
            result = 31 * result + this.highLevelType.hashCode();
            result = 31 * result + this.primitiveType.hashCode();
            return result;
        }
    }
}

