/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.models.result;

import com.mnubo.java.sdk.client.models.result.ResultValue;
import java.util.UUID;
import org.joda.time.DateTime;

public class BooleanValue
implements ResultValue {
    private final boolean value;

    public BooleanValue(boolean value) {
        this.value = value;
    }

    @Override
    public boolean booleanValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value ? 1 : 0;
    }

    @Override
    public long longValue() {
        return this.value ? 1L : 0L;
    }

    @Override
    public float floatValue() {
        return this.value ? 1.0f : 0.0f;
    }

    @Override
    public double doubleValue() {
        return this.value ? 1.0 : 0.0;
    }

    @Override
    public String strValue() {
        return String.valueOf(this.value);
    }

    @Override
    public DateTime datetimeValue() {
        throw new NumberFormatException("Cannot convert a boolean to DateTime");
    }

    @Override
    public UUID uuidValue() {
        throw new NumberFormatException("Cannot convert a boolean to uuid");
    }

    public boolean equals(Object obj) {
        if (obj instanceof BooleanValue) {
            return this.value == ((BooleanValue)obj).booleanValue();
        }
        return false;
    }

    public int hashCode() {
        return Boolean.valueOf(this.value).hashCode();
    }
}

