/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.models;

import com.mnubo.java.sdk.client.models.Owner;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public final class SmartObject {
    public static final String DEVICE_ID = "x_device_id";
    public static final String OBJECT_TYPE = "x_object_type";
    public static final String REGISTRATION_DATE = "x_registration_date";
    public static final String OWNER = "x_owner";
    public static final String EVENT_ID = "event_id";
    private final String deviceId;
    private final UUID objectId = null;
    private final String objectType;
    private final DateTime registrationDate;
    private final Owner owner;
    private final Map<String, Object> attributes;
    private final UUID eventId;

    SmartObject(String deviceId, String objectType, DateTime registrationDate, Owner owner, Map<String, Object> attributes, UUID eventId) {
        this.deviceId = deviceId;
        this.objectType = objectType;
        this.registrationDate = registrationDate == null ? null : registrationDate.withZone(DateTimeZone.UTC);
        this.owner = owner;
        this.eventId = eventId;
        this.attributes = new HashMap<String, Object>();
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                String timeSerieName = entry.getKey();
                Object timeSerieValue = entry.getValue();
                if (this.attributes.containsKey(timeSerieName.toLowerCase())) {
                    throw new IllegalArgumentException(String.format("Duplicate field '%s'.", timeSerieName));
                }
                this.attributes.put(timeSerieName.toLowerCase(), timeSerieValue);
            }
        }
    }

    public static SmartObjectBuilder builder() {
        return new SmartObjectBuilder();
    }

    public Map<String, Object> getAttributes() {
        return new HashMap<String, Object>(this.attributes);
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public UUID getObjectId() {
        return this.objectId;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public DateTime getRegistrationDate() {
        return this.registrationDate;
    }

    public String getOwnerUserName() {
        if (this.owner == null) {
            return null;
        }
        return this.owner.getUsername();
    }

    public Owner getOwner() {
        return this.owner;
    }

    public UUID getEventId() {
        return this.eventId;
    }

    public String toString() {
        StringBuilder toPrint = new StringBuilder();
        toPrint.append("{\n");
        toPrint.append(this.line2String(DEVICE_ID, this.deviceId));
        toPrint.append(this.line2String("OBJECT_ID", this.objectId));
        toPrint.append(this.line2String(OBJECT_TYPE, this.objectType));
        toPrint.append(this.line2String(REGISTRATION_DATE, this.registrationDate));
        toPrint.append(this.line2String("x_owner.username", this.owner != null ? this.owner.getUsername() : null));
        toPrint.append(this.line2String(EVENT_ID, this.eventId != null ? this.eventId.toString() : ""));
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            toPrint.append(this.line2String(entry.getKey(), entry.getValue()));
        }
        toPrint.append("}\n");
        return toPrint.toString();
    }

    private String line2String(String name, Object value) {
        StringBuilder build = new StringBuilder();
        if (name != null) {
            build.append("     " + name + " : ");
            if (value != null) {
                build.append(value);
            } else {
                build.append("");
            }
            build.append("\n");
        }
        return build.toString();
    }

    public static class SmartObjectBuilder {
        private String deviceId;
        private String objectType;
        private DateTime registrationDate;
        private Owner owner;
        private Map<String, Object> attributes = new HashMap<String, Object>();
        private UUID eventId;

        SmartObjectBuilder() {
        }

        public SmartObjectBuilder withDeviceId(String deviceId) throws IllegalStateException {
            this.deviceId = deviceId;
            return this;
        }

        public SmartObjectBuilder withObjectType(String objectType) throws IllegalStateException {
            this.objectType = objectType;
            return this;
        }

        public SmartObjectBuilder withRegistrationDate(DateTime registrationDate) {
            this.registrationDate = registrationDate == null ? null : registrationDate.withZone(DateTimeZone.UTC);
            return this;
        }

        public SmartObjectBuilder withOwner(String ownerUsername) {
            this.owner = Owner.builder().withUsername(ownerUsername).build();
            return this;
        }

        public SmartObjectBuilder withAttributes(Map<String, Object> attributes) {
            this.attributes = attributes;
            return this;
        }

        public SmartObjectBuilder withAddedAttribute(String key, Object value) {
            this.attributes.put(key, value);
            return this;
        }

        public SmartObjectBuilder withEventId(UUID eventId) {
            this.eventId = eventId;
            return this;
        }

        public SmartObject build() {
            return new SmartObject(this.deviceId, this.objectType, this.registrationDate, this.owner, this.attributes, this.eventId);
        }
    }
}

