/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.models;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public final class Owner {
    public static final String REGISTRATION_DATE = "x_registration_date";
    public static final String PASSWORD = "x_password";
    public static final String USERNAME = "username";
    public static final String EVENT_ID = "event_id";
    private final String username;
    private final String password;
    private final DateTime registrationDate;
    private final Map<String, Object> attributes;
    private final UUID eventId;

    Owner(String username, String password, DateTime registrationDate, Map<String, Object> attributes, UUID eventId) {
        this.username = username != null ? username.toLowerCase() : null;
        this.password = password;
        this.registrationDate = registrationDate == null ? null : registrationDate.withZone(DateTimeZone.UTC);
        this.eventId = eventId;
        this.attributes = new HashMap<String, Object>();
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                String timeSerieName = entry.getKey();
                Object timeSerieValue = entry.getValue();
                if (this.attributes.containsKey(timeSerieName.toLowerCase())) {
                    throw new IllegalArgumentException(String.format("Duplicate field '%s'.", timeSerieName));
                }
                this.attributes.put(timeSerieName.toLowerCase(), timeSerieValue);
            }
        }
    }

    public static OwnerBuilder builder() {
        return new OwnerBuilder();
    }

    public Map<String, Object> getAttributes() {
        return new HashMap<String, Object>(this.attributes);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public DateTime getRegistrationDate() {
        return this.registrationDate;
    }

    public UUID getEventId() {
        return this.eventId;
    }

    public String toString() {
        StringBuilder toPrint = new StringBuilder();
        toPrint.append("{\n");
        toPrint.append(this.line2String(USERNAME, this.username));
        toPrint.append(this.line2String(PASSWORD, this.password));
        toPrint.append(this.line2String(REGISTRATION_DATE, this.registrationDate));
        toPrint.append(this.line2String(EVENT_ID, this.eventId != null ? this.eventId.toString() : ""));
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            toPrint.append(this.line2String(entry.getKey(), entry.getValue()));
        }
        toPrint.append("}\n");
        return toPrint.toString();
    }

    private String line2String(String name, Object value) {
        StringBuilder build = new StringBuilder();
        if (name != null) {
            build.append("     " + name + " : ");
            if (value != null) {
                build.append(value);
            } else {
                build.append("");
            }
            build.append("\n");
        }
        return build.toString();
    }

    public static class OwnerBuilder {
        private String username;
        private String password;
        private DateTime registrationDate;
        private Map<String, Object> attributes = new HashMap<String, Object>();
        private UUID eventId;

        OwnerBuilder() {
        }

        public OwnerBuilder withUsername(String username) throws IllegalStateException {
            this.username = username;
            return this;
        }

        public OwnerBuilder withPassword(String password) {
            this.password = password;
            return this;
        }

        public OwnerBuilder withRegistrationDate(DateTime registrationDate) {
            this.registrationDate = registrationDate == null ? null : registrationDate.withZone(DateTimeZone.UTC);
            return this;
        }

        public OwnerBuilder withAttributes(Map<String, Object> attributes) {
            this.attributes = attributes;
            return this;
        }

        public OwnerBuilder withAddedAttribute(String key, Object value) {
            this.attributes.put(key, value);
            return this;
        }

        public OwnerBuilder withEventId(UUID eventId) {
            this.eventId = eventId;
            return this;
        }

        public Owner build() {
            return new Owner(this.username, this.password, this.registrationDate, this.attributes, this.eventId);
        }
    }
}

