/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.models;

import com.google.common.base.Preconditions;

public final class Field {
    String key;
    String highLevelType;
    String displayName;
    String description;
    String containerType;
    boolean isPrimaryKey;

    public Field(String key, String highLevelType, String displayName, String description, String containerType) {
        Preconditions.checkNotNull((Object)key, (Object)"key must not be null");
        Preconditions.checkNotNull((Object)highLevelType, (Object)"highLevelType must not be null");
        this.key = key;
        this.highLevelType = highLevelType;
        this.displayName = displayName;
        this.description = description;
        this.containerType = containerType != null ? containerType : "none";
    }

    public String getKey() {
        return this.key;
    }

    public String getHighLevelType() {
        return this.highLevelType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContainerType() {
        return this.containerType;
    }

    public String toString() {
        StringBuilder toPrint = new StringBuilder();
        toPrint.append("{\n");
        toPrint.append(this.line2String("key", this.key));
        toPrint.append(this.line2String("highLevelType", this.highLevelType));
        toPrint.append(this.line2String("displayName", this.displayName));
        toPrint.append(this.line2String("containerType", this.containerType.toString()));
        toPrint.append(this.line2String("isPrimaryKey", this.isPrimaryKey));
        toPrint.append("}\n");
        return toPrint.toString();
    }

    private String line2String(String name, Object value) {
        StringBuilder build = new StringBuilder();
        if (name != null) {
            build.append("     " + name + " : ");
            if (value != null) {
                build.append(value);
            } else {
                build.append("");
            }
            build.append("\n");
        }
        return build.toString();
    }
}

