/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.models;

import com.mnubo.java.sdk.client.models.SmartObject;
import com.mnubo.java.sdk.client.utils.ValidationUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public final class Event {
    public static final String EVENT_ID = "event_id";
    public static final String OBJECT = "x_object";
    public static final String EVENT_TYPE = "x_event_type";
    public static final String TIMESTAMP = "x_timestamp";
    private final UUID eventId;
    private final SmartObject smartObject;
    private final String eventType;
    private final DateTime timestamp;
    private final Map<String, Object> timeseries;

    Event(UUID eventId, SmartObject smartObject, String eventType, DateTime timestamp, Map<String, Object> timeseries) {
        ValidationUtils.notBlank(eventType, "X_Event_Type cannot be null or empty");
        this.eventId = eventId;
        this.smartObject = smartObject;
        this.eventType = eventType;
        this.timestamp = timestamp != null ? timestamp.withZone(DateTimeZone.UTC) : DateTime.now().withZone(DateTimeZone.UTC);
        this.timeseries = new HashMap<String, Object>();
        if (timeseries != null) {
            for (Map.Entry<String, Object> entry : timeseries.entrySet()) {
                String timeSerieName = entry.getKey();
                Object timeSerieValue = entry.getValue();
                if (this.timeseries.containsKey(timeSerieName.toLowerCase())) {
                    throw new IllegalArgumentException(String.format("Duplicate field '%s'.", timeSerieName));
                }
                this.timeseries.put(timeSerieName.toLowerCase(), timeSerieValue);
            }
        }
    }

    public static EventBuilder builder() {
        return new EventBuilder();
    }

    public Map<String, Object> getTimeseries() {
        return new HashMap<String, Object>(this.timeseries);
    }

    public String getDeviceId() {
        if (this.smartObject == null || this.smartObject.getDeviceId() == null) {
            return null;
        }
        return this.smartObject.getDeviceId();
    }

    public String getObjectId() {
        if (this.smartObject == null || this.smartObject.getObjectId() == null) {
            return null;
        }
        return this.smartObject.getObjectId().toString();
    }

    public UUID getEventId() {
        return this.eventId;
    }

    public SmartObject getObject() {
        return this.smartObject;
    }

    public String getEventType() {
        return this.eventType;
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        StringBuilder toPrint = new StringBuilder();
        toPrint.append("{\n");
        toPrint.append(this.line2String("x_object.x_device_id", this.smartObject != null ? this.smartObject.getDeviceId() : null));
        toPrint.append(this.line2String(EVENT_ID, this.eventId));
        toPrint.append(this.line2String(EVENT_TYPE, this.eventType));
        toPrint.append(this.line2String(TIMESTAMP, this.timestamp));
        for (Map.Entry<String, Object> entry : this.timeseries.entrySet()) {
            toPrint.append(this.line2String(entry.getKey(), entry.getValue()));
        }
        toPrint.append("}\n");
        return toPrint.toString();
    }

    private String line2String(String name, Object value) {
        StringBuilder build = new StringBuilder();
        if (name != null) {
            build.append("     " + name + " : ");
            if (value != null) {
                build.append(value);
            } else {
                build.append("");
            }
            build.append("\n");
        }
        return build.toString();
    }

    public static class EventBuilder {
        private UUID eventId;
        private SmartObject smartObject;
        private String eventType;
        private DateTime timestamp = DateTime.now().withZone(DateTimeZone.UTC);
        private Map<String, Object> timeseries = new HashMap<String, Object>();

        EventBuilder() {
        }

        public EventBuilder withEventID(UUID eventId) {
            this.eventId = eventId;
            return this;
        }

        public EventBuilder withSmartObject(String deviceId) {
            this.smartObject = SmartObject.builder().withDeviceId(deviceId).withObjectType("send event").build();
            return this;
        }

        public EventBuilder withEventType(String eventType) throws IllegalStateException {
            this.eventType = eventType;
            return this;
        }

        public EventBuilder withTimestamp(DateTime timestamp) {
            this.timestamp = timestamp == null ? null : timestamp.withZone(DateTimeZone.UTC);
            return this;
        }

        public EventBuilder withTimeseries(Map<String, Object> timeseries) {
            this.timeseries = timeseries;
            return this;
        }

        public EventBuilder withAddedTimeseries(String key, Object value) {
            this.timeseries.put(key, value);
            return this;
        }

        public Event build() {
            return new Event(this.eventId, this.smartObject, this.eventType, this.timestamp, this.timeseries);
        }
    }
}

