/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.models;

import com.google.common.base.Preconditions;
import com.mnubo.java.sdk.client.models.Field;
import java.util.Set;

public final class DataSet {
    private final String key;
    private final String description;
    private final String displayName;
    private final Set<Field> fields;

    public DataSet(String key, String description, String displayName, Set<Field> fields) {
        Preconditions.checkNotNull((Object)key, (Object)"Dataset key must not be null");
        Preconditions.checkNotNull(fields, (Object)"Dataset fields must not be null");
        this.key = key;
        this.description = description;
        this.displayName = displayName;
        this.fields = fields;
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Set<Field> getFields() {
        return this.fields;
    }

    public String toString() {
        StringBuilder toPrint = new StringBuilder();
        toPrint.append("{\n");
        toPrint.append(this.line2String("key", this.key));
        toPrint.append(this.line2String("description", this.description));
        toPrint.append(this.line2String("displayName", this.displayName));
        for (Field f : this.fields) {
            toPrint.append(this.line2String(f.description, f.toString()));
        }
        toPrint.append("}\n");
        return toPrint.toString();
    }

    private String line2String(String name, Object value) {
        StringBuilder build = new StringBuilder();
        if (name != null) {
            build.append("     " + name + " : ");
            if (value != null) {
                build.append(value);
            } else {
                build.append("");
            }
            build.append("\n");
        }
        return build.toString();
    }
}

