/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.mapper;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.mnubo.java.sdk.client.models.SmartObject;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SmartObjectSerializer
extends StdSerializer<SmartObject> {
    public SmartObjectSerializer() {
        super(SmartObject.class);
    }

    public void serialize(SmartObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        if (value.getRegistrationDate() != null) {
            jgen.writeStringField("x_registration_date", value.getRegistrationDate().toString());
        }
        if (value.getDeviceId() != null) {
            jgen.writeStringField("x_device_id", value.getDeviceId());
        }
        if (value.getObjectType() != null) {
            jgen.writeStringField("x_object_type", value.getObjectType());
        }
        if (value.getOwner() != null && StringUtils.isNotBlank((CharSequence)value.getOwnerUserName())) {
            jgen.writeObjectFieldStart("x_owner");
            jgen.writeStringField("username", value.getOwnerUserName());
            jgen.writeEndObject();
        }
        if (value.getEventId() != null) {
            jgen.writeObjectField("event_id", (Object)value.getEventId());
        }
        if (value.getAttributes() != null) {
            for (Map.Entry<String, Object> entry : value.getAttributes().entrySet()) {
                jgen.writeObjectField(entry.getKey(), entry.getValue());
            }
        }
        jgen.writeEndObject();
    }
}

