/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.mapper;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mnubo.java.sdk.client.mapper.MapperUtils;
import com.mnubo.java.sdk.client.models.SmartObject;
import java.io.IOException;
import java.util.Map;

public class SmartObjectDeserializer
extends StdDeserializer<SmartObject> {
    public SmartObjectDeserializer() {
        super(SmartObject.class);
    }

    public SmartObject deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        SmartObject.SmartObjectBuilder builder = SmartObject.builder();
        Map<String, Object> items = MapperUtils.readValuesAsMap(jsonParser, String.class, Object.class);
        for (Map.Entry<String, Object> entry : items.entrySet()) {
            String fieldName = entry.getKey();
            Object fieldValue = entry.getValue();
            if (entry.getKey().equals("x_device_id")) {
                MapperUtils.throwIfNotProperType("x_device_id", fieldValue, "TEXT");
                builder.withDeviceId(entry.getValue().toString());
                continue;
            }
            if (entry.getKey().equals("x_object_type")) {
                MapperUtils.throwIfNotProperType("x_object_type", fieldValue, "TEXT");
                builder.withObjectType(entry.getValue().toString());
                continue;
            }
            if (entry.getKey().equals("x_owner")) {
                Map objectMap;
                MapperUtils.throwIfNotProperType("x_owner", fieldValue, "SMARTOBJECT");
                if (!(fieldValue instanceof Map) || !(objectMap = (Map)fieldValue).containsKey("username")) continue;
                Object username = objectMap.get("username");
                MapperUtils.throwIfNotProperType(String.format("%s.%s", "x_owner", "username"), username, "TEXT");
                builder.withOwner(MapperUtils.convertToString(username));
                continue;
            }
            if (entry.getKey().equals("x_registration_date")) {
                MapperUtils.throwIfNotProperType("x_registration_date", fieldValue, "DATETIME");
                builder.withRegistrationDate(MapperUtils.convertToDatetime(fieldValue.toString()));
                continue;
            }
            if (entry.getKey().equals("event_id")) {
                MapperUtils.throwIfNotProperType("event_id", fieldValue, "UUID");
                builder.withEventId(MapperUtils.convertToUUID(fieldValue.toString()));
                continue;
            }
            if (fieldName.toLowerCase().equals("x_device_id") || fieldName.toLowerCase().equals("x_object_type") || fieldName.toLowerCase().equals("x_owner") || fieldName.toLowerCase().equals("x_registration_date") || fieldName.toLowerCase().equals("event_id")) {
                throw new IllegalArgumentException(String.format("Reserved field %s must be lowercase.", fieldName.toLowerCase()));
            }
            builder.withAddedAttribute(fieldName, fieldValue);
        }
        return builder.build();
    }
}

