/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.mapper;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mnubo.java.sdk.client.mapper.MapperUtils;
import com.mnubo.java.sdk.client.models.Owner;
import java.io.IOException;
import java.util.Map;

public class OwnerDeserializer
extends StdDeserializer<Owner> {
    public OwnerDeserializer() {
        super(Owner.class);
    }

    public Owner deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        Owner.OwnerBuilder builder = Owner.builder();
        Map<String, Object> items = MapperUtils.readValuesAsMap(jsonParser, String.class, Object.class);
        for (Map.Entry<String, Object> entry : items.entrySet()) {
            String fieldName = entry.getKey();
            Object fieldValue = entry.getValue();
            if (fieldName.equals("username")) {
                MapperUtils.throwIfNotProperType("username", fieldValue, "TEXT");
                builder.withUsername(MapperUtils.convertToString(fieldValue.toString()));
                continue;
            }
            if (fieldName.equals("x_password")) {
                MapperUtils.throwIfNotProperType("x_password", fieldValue, "TEXT");
                builder.withPassword(MapperUtils.convertToString(fieldValue.toString()));
                continue;
            }
            if (fieldName.equals("x_registration_date")) {
                MapperUtils.throwIfNotProperType("x_registration_date", fieldValue, "DATETIME");
                builder.withRegistrationDate(MapperUtils.convertToDatetime(fieldValue.toString()));
                continue;
            }
            if (fieldName.equals("event_id")) {
                MapperUtils.throwIfNotProperType("event_id", fieldValue, "UUID");
                builder.withEventId(MapperUtils.convertToUUID(fieldValue.toString()));
                continue;
            }
            if (fieldName.toLowerCase().equals("username") || fieldName.toLowerCase().equals("x_password") || fieldName.toLowerCase().equals("x_registration_date") || fieldName.toLowerCase().equals("event_id")) {
                throw new IllegalArgumentException(String.format("Reserved field %s must be lowercase.", fieldName.toLowerCase()));
            }
            builder.withAddedAttribute(fieldName, fieldValue);
        }
        return builder.build();
    }
}

