/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.mapper;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.joda.deser.IntervalDeserializer;
import com.fasterxml.jackson.datatype.joda.ser.IntervalSerializer;
import com.mnubo.java.sdk.client.mapper.EventDeserializer;
import com.mnubo.java.sdk.client.mapper.EventSerializer;
import com.mnubo.java.sdk.client.mapper.OwnerDeserializer;
import com.mnubo.java.sdk.client.mapper.OwnerSerializer;
import com.mnubo.java.sdk.client.mapper.SmartObjectDeserializer;
import com.mnubo.java.sdk.client.mapper.SmartObjectSerializer;
import com.mnubo.java.sdk.client.models.Event;
import com.mnubo.java.sdk.client.models.Owner;
import com.mnubo.java.sdk.client.models.SmartObject;
import org.joda.time.Interval;
import org.springframework.http.converter.json.Jackson2ObjectMapperFactoryBean;

public abstract class ObjectMapperConfig {
    public static ObjectMapper getObjectMapper() {
        Jackson2ObjectMapperFactoryBean factory = new Jackson2ObjectMapperFactoryBean();
        factory.setFeaturesToDisable(new Object[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS});
        factory.setFeaturesToEnable(new Object[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
        factory.setFindModulesViaServiceLoader(false);
        factory.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        factory.setIndentOutput(false);
        factory.afterPropertiesSet();
        ObjectMapper objectMapper = factory.getObject();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS, true);
        objectMapper.registerModule((Module)ObjectMapperConfig.createJodaModule());
        objectMapper.registerModule((Module)ObjectMapperConfig.createSmartObject());
        objectMapper.registerModule((Module)ObjectMapperConfig.createOwner());
        objectMapper.registerModule((Module)ObjectMapperConfig.createEvent());
        return objectMapper;
    }

    private static SimpleModule createJodaModule() {
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new IntervalSerializer());
        module.addDeserializer(Interval.class, (JsonDeserializer)new IntervalDeserializer());
        return module;
    }

    private static SimpleModule createSmartObject() {
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new SmartObjectSerializer());
        module.addDeserializer(SmartObject.class, (JsonDeserializer)new SmartObjectDeserializer());
        return module;
    }

    private static SimpleModule createOwner() {
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new OwnerSerializer());
        module.addDeserializer(Owner.class, (JsonDeserializer)new OwnerDeserializer());
        return module;
    }

    private static SimpleModule createEvent() {
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new EventSerializer());
        module.addDeserializer(Event.class, (JsonDeserializer)new EventDeserializer());
        return module;
    }
}

