/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.mapper;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.mnubo.java.sdk.client.mapper.ObjectMapperConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

abstract class MapperUtils {
    static final String TEXT_TYPE = "TEXT";
    static final String UUID_TYPE = "UUID";
    static final String DATETIME_TYPE = "DATETIME";
    static final String OWNER_INSTANCE_TYPE = "OWNER";
    static final String OBJECT_INSTANCE_TYPE = "SMARTOBJECT";
    static final List<String> DATETIME_PATTERNS = Arrays.asList("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    static final DateTimeParser[] dateTimeParsers = new DateTimeParser[DATETIME_PATTERNS.size()];
    static final DateTimeFormatter dateTimeFormatter;
    static ObjectMapper objectMapper;

    MapperUtils() {
    }

    static <T> T readValue(String content, Class<T> valueType) throws IllegalStateException {
        try {
            return (T)objectMapper.readValue(content, valueType);
        }
        catch (Exception e) {
            throw new IllegalStateException("reading json content", e.getCause());
        }
    }

    static <V, T> Map<V, T> readValuesAsMap(JsonParser parser, Class<V> keyType, Class<T> valueType) throws IllegalStateException {
        try {
            MapType stringMapTypew = MapType.construct(HashMap.class, (JavaType)SimpleType.construct(keyType), (JavaType)SimpleType.construct(valueType));
            return (HashMap)objectMapper.readValue(parser, (JavaType)stringMapTypew);
        }
        catch (Exception e) {
            throw new IllegalStateException("reading json content", e.getCause());
        }
    }

    static void throwIfNotProperType(String name, Object value, String type) {
        if (value != null) {
            switch (type) {
                case "TEXT": {
                    if (value instanceof String) break;
                    MapperUtils.throwIllegalArgument(name, value.toString(), type);
                    break;
                }
                case "DATETIME": {
                    try {
                        dateTimeFormatter.parseDateTime(value.toString());
                        break;
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException(String.format("Field '%s' value '%s' does not match TYPE '%s' pattern supported", name, value, type));
                    }
                }
                case "UUID": {
                    try {
                        UUID.fromString(value.toString());
                        break;
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException("UUID has to be represented by the standard 36-char representation");
                    }
                }
                case "OWNER": {
                    if (value instanceof Map) break;
                    MapperUtils.throwIllegalArgument(name, value.toString(), type);
                    break;
                }
                case "SMARTOBJECT": {
                    if (value instanceof Map) break;
                    MapperUtils.throwIllegalArgument(name, value.toString(), type);
                }
            }
        }
    }

    static void throwIllegalArgument(String name, String value, String type) {
        throw new IllegalArgumentException(String.format("Field '%s' value '%s' does not match TYPE '%s'", name, value, type));
    }

    static String convertToString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    static UUID convertToUUID(Object value) {
        if (value == null) {
            return null;
        }
        return UUID.fromString(value.toString());
    }

    static DateTime convertToDatetime(Object value) {
        if (value == null) {
            return null;
        }
        return DateTime.parse((String)value.toString()).withZone(DateTimeZone.UTC);
    }

    static {
        for (int point = 0; point < DATETIME_PATTERNS.size(); ++point) {
            MapperUtils.dateTimeParsers[point] = DateTimeFormat.forPattern((String)DATETIME_PATTERNS.get(point)).getParser();
        }
        dateTimeFormatter = new DateTimeFormatterBuilder().append(null, dateTimeParsers).toFormatter();
        objectMapper = ObjectMapperConfig.getObjectMapper();
    }
}

