/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.mapper;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.mnubo.java.sdk.client.models.Event;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class EventSerializer
extends StdSerializer<Event> {
    public EventSerializer() {
        super(Event.class);
    }

    public void serialize(Event value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        if (value.getTimestamp() != null) {
            jgen.writeStringField("x_timestamp", value.getTimestamp().toString());
        }
        if (value.getObject() != null && StringUtils.isNotBlank((CharSequence)value.getDeviceId())) {
            jgen.writeObjectFieldStart("x_object");
            jgen.writeStringField("x_device_id", value.getDeviceId());
            jgen.writeEndObject();
        }
        if (value.getEventId() != null) {
            jgen.writeObjectField("event_id", (Object)value.getEventId());
        }
        if (value.getEventType() != null) {
            jgen.writeStringField("x_event_type", value.getEventType());
        }
        if (value.getTimeseries() != null) {
            for (Map.Entry<String, Object> entry : value.getTimeseries().entrySet()) {
                jgen.writeObjectField(entry.getKey(), entry.getValue());
            }
        }
        jgen.writeEndObject();
    }
}

