/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.mapper;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mnubo.java.sdk.client.mapper.MapperUtils;
import com.mnubo.java.sdk.client.models.Event;
import java.io.IOException;
import java.util.Map;

public class EventDeserializer
extends StdDeserializer<Event> {
    public EventDeserializer() {
        super(Event.class);
    }

    public Event deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        Event.EventBuilder builder = Event.builder();
        Map<String, Object> items = MapperUtils.readValuesAsMap(jsonParser, String.class, Object.class);
        for (Map.Entry<String, Object> entry : items.entrySet()) {
            String fieldName = entry.getKey();
            Object fieldValue = entry.getValue();
            if (fieldName.equals("event_id")) {
                MapperUtils.throwIfNotProperType("event_id", fieldValue, "UUID");
                builder.withEventID(MapperUtils.convertToUUID(fieldValue));
                continue;
            }
            if (fieldName.equals("x_event_type")) {
                MapperUtils.throwIfNotProperType("x_event_type", fieldValue, "TEXT");
                builder.withEventType(MapperUtils.convertToString(fieldValue));
                continue;
            }
            if (fieldName.equals("x_object")) {
                Map objectMap;
                MapperUtils.throwIfNotProperType("x_object", fieldValue, "SMARTOBJECT");
                if (!(fieldValue instanceof Map) || !(objectMap = (Map)fieldValue).containsKey("x_device_id")) continue;
                Object deviceId = objectMap.get("x_device_id");
                MapperUtils.throwIfNotProperType(String.format("%s.%s", "x_object", "x_device_id"), deviceId, "TEXT");
                builder.withSmartObject(MapperUtils.convertToString(deviceId));
                continue;
            }
            if (fieldName.equals("x_timestamp")) {
                MapperUtils.throwIfNotProperType("x_timestamp", fieldValue, "DATETIME");
                builder.withTimestamp(MapperUtils.convertToDatetime(fieldValue));
                continue;
            }
            if (fieldName.toLowerCase().equals("x_object") || fieldName.toLowerCase().equals("x_event_type") || fieldName.toLowerCase().equals("x_timestamp") || fieldName.toLowerCase().equals("event_id")) {
                throw new IllegalArgumentException(String.format("Reserved field %s must be lowercase.", fieldName.toLowerCase()));
            }
            builder.withAddedTimeseries(fieldName, fieldValue);
        }
        return builder.build();
    }
}

