/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.config;

import com.mnubo.java.sdk.client.utils.ValidationUtils;

public class MnuboSDKConfig {
    public static final String DEFAULT_SCOPE = "ALL";
    public static final boolean DEFAULT_DISABLE_COOKIE_MANAGEMENT = true;
    public static final boolean DEFAULT_SYSTEM_PROPERTIES_ENABLE = true;
    private final String hostName;
    private final String SecurityConsumerKey;
    private final String SecurityConsumerSecret;
    private final int platformPort;
    private final int restitutionPort;
    private final int authenticationPort;
    private final String scope = "ALL";
    private final String httpProtocol;
    private final boolean httpDisableCockieManagement = true;
    private final boolean httpDisableRedirectHandling;
    private final boolean httpDisableAutomaticRetries;
    private final boolean httpSystemPropertiesEnable = true;
    private final int httpMaxTotalConnection;
    private final int httpMaxConnectionPerRoute;
    private final int httpDefaultTimeout;
    private final int httpConnectionTimeout;
    private final int httpConnectionRequestTimeout;
    private final int httpSoketTimeout;
    private final String basePath;

    private MnuboSDKConfig(String hostName, String SecurityConsumerKey, String SecurityConsumerSecret, int platformPort, int restitutionPort, int authenticationPort, String httpProtocol, int httpDefaultTimeout, boolean httpDisableRedirectHandling, String basePath, boolean httpDisableAutomaticRetries, int httpSoketTimeout, int httpMaxTotalConnection, int httpMaxConnectionPerRoute, int httpConnectionTimeout, int httpConnectionRequestTimeout) {
        this.hostName = ValidationUtils.parseAsString(hostName, "client.config.hostname");
        this.SecurityConsumerKey = ValidationUtils.parseAsString(SecurityConsumerKey, "client.security.consumer-key");
        this.SecurityConsumerSecret = ValidationUtils.parseAsString(SecurityConsumerSecret, "client.security.consumer-secret");
        this.platformPort = ValidationUtils.parseAsPort(Integer.toString(platformPort), "client.config.ingestion-port");
        this.restitutionPort = ValidationUtils.parseAsPort(Integer.toString(restitutionPort), "client.config.restitution-port");
        this.authenticationPort = ValidationUtils.parseAsPort(Integer.toString(authenticationPort), "client.config.autentication-port");
        this.httpProtocol = ValidationUtils.parseAsHttpProtocol(httpProtocol);
        this.httpDefaultTimeout = ValidationUtils.parseAsInteger(Integer.toString(httpDefaultTimeout), "client.http.client.http.client.default-timeout");
        this.httpDisableRedirectHandling = ValidationUtils.parseAsBoolean(Boolean.toString(httpDisableRedirectHandling), "client.http.client.disable-redirect-handling");
        this.basePath = ValidationUtils.parseAsString(basePath, "client.http.client.base-path");
        this.httpDisableAutomaticRetries = ValidationUtils.parseAsBoolean(Boolean.toString(httpDisableAutomaticRetries), "client.http.client.disable-automatic-retries");
        this.httpMaxTotalConnection = ValidationUtils.parseAsInteger(Integer.toString(httpMaxTotalConnection), "client.http.client.max-total-connection");
        this.httpConnectionRequestTimeout = ValidationUtils.parseAsInteger(Integer.toString(httpConnectionRequestTimeout), "client.http.client.connection-request-timeout");
        this.httpMaxConnectionPerRoute = ValidationUtils.parseAsInteger(Integer.toString(httpMaxConnectionPerRoute), "client.http.client.max-connections-per-route");
        this.httpConnectionTimeout = ValidationUtils.parseAsInteger(Integer.toString(httpConnectionTimeout), "client.http.client.http.client.connect-timeout");
        this.httpSoketTimeout = ValidationUtils.parseAsInteger(Integer.toString(httpSoketTimeout), "client.http.client.http.client.socket-timeout");
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPlatformPort() {
        return this.platformPort;
    }

    public int getRestitutionPort() {
        return this.restitutionPort;
    }

    public int getAuthenticationPort() {
        return this.authenticationPort;
    }

    public String getSecurityConsumerKey() {
        return this.SecurityConsumerKey;
    }

    public String getSecurityConsumerSecret() {
        return this.SecurityConsumerSecret;
    }

    public String getScope() {
        return DEFAULT_SCOPE;
    }

    public String getHttpProtocol() {
        return this.httpProtocol;
    }

    public boolean isHttpDisableCockieManagement() {
        return true;
    }

    public boolean isHttpDisableRedirectHandling() {
        return this.httpDisableRedirectHandling;
    }

    public boolean isHttpDisableAutomaticRetries() {
        return this.httpDisableAutomaticRetries;
    }

    public boolean isHttpSystemPropertiesEnable() {
        return true;
    }

    public int getHttpMaxConnectionPerRoute() {
        return this.httpMaxConnectionPerRoute;
    }

    public int getHttpDefaultTimeout() {
        return this.httpDefaultTimeout;
    }

    public int getHttpConnectionRequestTimeout() {
        return this.httpConnectionRequestTimeout;
    }

    public int getHttpSoketTimeout() {
        return this.httpSoketTimeout;
    }

    public int getHttpMaxTotalConnection() {
        return this.httpMaxTotalConnection;
    }

    public String getHttpBasePath() {
        return this.basePath;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        public static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 200;
        public static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 200;
        public static final int DEFAULT_TIMEOUT = 50000;
        public static final int DEFAULT_HOST_PORT = 443;
        public static final String DEFAULT_CLIENT_PROTOCOL = "https";
        public static final String DEFAULT_BASE_PATH = "/api/v3";
        public static final boolean DEFAULT_DISABLE_REDIRECT_HANDLING = false;
        public static final boolean DEFAULT_DISABLE_AUTOMATIC_RETRIES = false;
        private String hostName;
        private String SecurityConsumerKey;
        private String SecurityConsumerSecret;
        private int platformPort = 443;
        private int restitutionPort = 443;
        private int authenticationPort = 443;
        private String httpProtocol = "https";
        private boolean httpDisableRedirectHandling = false;
        private boolean httpDisableAutomaticRetries = false;
        private int httpMaxTotalConnection = 200;
        private int httpMaxConnectionPerRoute = 200;
        private int httpDefaultTimeout = 50000;
        private int httpConnectionTimeout = 50000;
        private int httpConnectionRequestTimeout = 50000;
        private int httpSocketTimeout = 50000;
        private String basePath = "/api/v3";

        public Builder withHostName(String platformServer) {
            this.hostName = ValidationUtils.parseAsString(platformServer, "client.config.hostname");
            return this;
        }

        public Builder withIngestionPort(String ingestionPort) {
            this.platformPort = ValidationUtils.parseAsPort(ingestionPort, "client.config.ingestion-port");
            return this;
        }

        public Builder withRestitutionPort(String restitutionPort) {
            this.restitutionPort = ValidationUtils.parseAsPort(restitutionPort, "client.config.restitution-port");
            return this;
        }

        public Builder withAuthenticationPort(String authenticationPort) {
            this.authenticationPort = ValidationUtils.parseAsPort(authenticationPort, "client.config.autentication-port");
            return this;
        }

        public Builder withSecurityConsumerKey(String securityConsumerkey) {
            this.SecurityConsumerKey = ValidationUtils.parseAsString(securityConsumerkey, "client.security.consumer-key");
            return this;
        }

        public Builder withSecurityConsumerSecret(String securityConsumerSecret) {
            this.SecurityConsumerSecret = ValidationUtils.parseAsString(securityConsumerSecret, "client.security.consumer-secret");
            return this;
        }

        public Builder withHttpProtocol(String httpProtocol) {
            this.httpProtocol = ValidationUtils.parseAsHttpProtocol(httpProtocol);
            return this;
        }

        public Builder withHttpDisableRedirectHandling(String httpDisableRedirectHandling) {
            this.httpDisableRedirectHandling = ValidationUtils.parseAsBoolean(httpDisableRedirectHandling, "client.http.client.disable-redirect-handling");
            return this;
        }

        public Builder withHttpDisableAutomaticRetries(String httpDisableAutomaticRetries) {
            this.httpDisableAutomaticRetries = ValidationUtils.parseAsBoolean(httpDisableAutomaticRetries, "client.http.client.disable-automatic-retries");
            return this;
        }

        public Builder withHttpMaxConnectionPerRoute(String maxConnectionPerRoute) {
            this.httpMaxConnectionPerRoute = ValidationUtils.parseAsInteger(maxConnectionPerRoute, "client.http.client.max-connections-per-route");
            return this;
        }

        public Builder withHttpDefaultTimeout(String httpDefaultTimeout) {
            this.httpDefaultTimeout = ValidationUtils.parseAsInteger(httpDefaultTimeout, "client.http.client.http.client.default-timeout");
            return this;
        }

        public Builder withHttpConnectionTimeout(String httpConnectionTiemout) {
            this.httpConnectionTimeout = ValidationUtils.parseAsInteger(httpConnectionTiemout, "client.http.client.http.client.connect-timeout");
            return this;
        }

        public Builder withHttpConnectionRequestTimeout(String httpConnectionRequestTimeout) {
            this.httpConnectionRequestTimeout = ValidationUtils.parseAsInteger(httpConnectionRequestTimeout, "client.http.client.connection-request-timeout");
            return this;
        }

        public Builder withHttpMaxTotalConnection(String maxTotalConnection) {
            this.httpMaxTotalConnection = ValidationUtils.parseAsInteger(maxTotalConnection, "client.http.client.max-total-connection");
            return this;
        }

        public Builder withHttpSocketTimeout(String httpSocketTimeout) {
            this.httpSocketTimeout = ValidationUtils.parseAsInteger(httpSocketTimeout, "client.http.client.http.client.socket-timeout");
            return this;
        }

        public Builder withHttpBasePath(String basePath) {
            this.basePath = ValidationUtils.parseAsString(basePath, "client.http.client.base-path");
            return this;
        }

        public MnuboSDKConfig build() {
            return new MnuboSDKConfig(this.hostName, this.SecurityConsumerKey, this.SecurityConsumerSecret, this.platformPort, this.restitutionPort, this.authenticationPort, this.httpProtocol, this.httpDefaultTimeout, this.httpDisableRedirectHandling, this.basePath, this.httpDisableAutomaticRetries, this.httpSocketTimeout, this.httpMaxTotalConnection, this.httpMaxConnectionPerRoute, this.httpConnectionTimeout, this.httpConnectionRequestTimeout);
        }
    }
}

