/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.serialization;

import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.ParseNodeFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.Consumer;

public abstract class ParseNodeProxyFactory
implements ParseNodeFactory {
    private final ParseNodeFactory _concrete;
    private final Consumer<Parsable> _onBefore;
    private final Consumer<Parsable> _onAfter;

    @Override
    @Nonnull
    public String getValidContentType() {
        return this._concrete.getValidContentType();
    }

    public ParseNodeProxyFactory(@Nonnull ParseNodeFactory concrete, @Nullable Consumer<Parsable> onBefore, @Nullable Consumer<Parsable> onAfter) {
        this._concrete = Objects.requireNonNull(concrete);
        this._onBefore = onBefore;
        this._onAfter = onAfter;
    }

    @Override
    @Nonnull
    public ParseNode getParseNode(@Nonnull String contentType, @Nonnull InputStream rawResponse) {
        Objects.requireNonNull(contentType);
        Objects.requireNonNull(rawResponse);
        ParseNode node = this._concrete.getParseNode(contentType, rawResponse);
        Consumer<Parsable> originalOnBefore = node.getOnBeforeAssignFieldValues();
        Consumer<Parsable> originalOnAfter = node.getOnAfterAssignFieldValues();
        node.setOnBeforeAssignFieldValues(x -> {
            if (this._onBefore != null) {
                this._onBefore.accept((Parsable)x);
            }
            if (originalOnBefore != null) {
                originalOnBefore.accept((Parsable)x);
            }
        });
        node.setOnAfterAssignFieldValues(x -> {
            if (this._onAfter != null) {
                this._onAfter.accept((Parsable)x);
            }
            if (originalOnAfter != null) {
                originalOnAfter.accept((Parsable)x);
            }
        });
        return node;
    }
}

