/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.ApplicationTemplate;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ApplicationTemplateRequest
extends BaseRequest<ApplicationTemplate> {
    public ApplicationTemplateRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ApplicationTemplate.class);
    }

    @Nonnull
    public CompletableFuture<ApplicationTemplate> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public ApplicationTemplate get() throws ClientException {
        return (ApplicationTemplate)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<ApplicationTemplate> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public ApplicationTemplate delete() throws ClientException {
        return (ApplicationTemplate)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<ApplicationTemplate> patchAsync(@Nonnull ApplicationTemplate sourceApplicationTemplate) {
        return this.sendAsync(HttpMethod.PATCH, sourceApplicationTemplate);
    }

    @Nullable
    public ApplicationTemplate patch(@Nonnull ApplicationTemplate sourceApplicationTemplate) throws ClientException {
        return (ApplicationTemplate)this.send(HttpMethod.PATCH, sourceApplicationTemplate);
    }

    @Nonnull
    public CompletableFuture<ApplicationTemplate> postAsync(@Nonnull ApplicationTemplate newApplicationTemplate) {
        return this.sendAsync(HttpMethod.POST, newApplicationTemplate);
    }

    @Nullable
    public ApplicationTemplate post(@Nonnull ApplicationTemplate newApplicationTemplate) throws ClientException {
        return (ApplicationTemplate)this.send(HttpMethod.POST, newApplicationTemplate);
    }

    @Nonnull
    public CompletableFuture<ApplicationTemplate> putAsync(@Nonnull ApplicationTemplate newApplicationTemplate) {
        return this.sendAsync(HttpMethod.PUT, newApplicationTemplate);
    }

    @Nullable
    public ApplicationTemplate put(@Nonnull ApplicationTemplate newApplicationTemplate) throws ClientException {
        return (ApplicationTemplate)this.send(HttpMethod.PUT, newApplicationTemplate);
    }

    @Nonnull
    public ApplicationTemplateRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ApplicationTemplateRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

