/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.Chat;
import com.microsoft.graph.models.ChatSendActivityNotificationParameterSet;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ChatMessageCollectionRequestBuilder;
import com.microsoft.graph.requests.ChatMessageRequestBuilder;
import com.microsoft.graph.requests.ChatRequest;
import com.microsoft.graph.requests.ChatSendActivityNotificationRequestBuilder;
import com.microsoft.graph.requests.ConversationMemberCollectionRequestBuilder;
import com.microsoft.graph.requests.ConversationMemberRequestBuilder;
import com.microsoft.graph.requests.PinnedChatMessageInfoCollectionRequestBuilder;
import com.microsoft.graph.requests.PinnedChatMessageInfoRequestBuilder;
import com.microsoft.graph.requests.TeamsAppInstallationCollectionRequestBuilder;
import com.microsoft.graph.requests.TeamsAppInstallationRequestBuilder;
import com.microsoft.graph.requests.TeamsTabCollectionRequestBuilder;
import com.microsoft.graph.requests.TeamsTabRequestBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChatRequestBuilder
extends BaseRequestBuilder<Chat> {
    public ChatRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    @Nonnull
    public ChatRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Nonnull
    public ChatRequest buildRequest(@Nonnull List<? extends Option> requestOptions) {
        return new ChatRequest(this.getRequestUrl(), this.getClient(), requestOptions);
    }

    @Nonnull
    public TeamsAppInstallationCollectionRequestBuilder installedApps() {
        return new TeamsAppInstallationCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("installedApps"), this.getClient(), null);
    }

    @Nonnull
    public TeamsAppInstallationRequestBuilder installedApps(@Nonnull String id) {
        return new TeamsAppInstallationRequestBuilder(this.getRequestUrlWithAdditionalSegment("installedApps") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public ConversationMemberCollectionRequestBuilder members() {
        return new ConversationMemberCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("members"), this.getClient(), null);
    }

    @Nonnull
    public ConversationMemberRequestBuilder members(@Nonnull String id) {
        return new ConversationMemberRequestBuilder(this.getRequestUrlWithAdditionalSegment("members") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public ChatMessageCollectionRequestBuilder messages() {
        return new ChatMessageCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("messages"), this.getClient(), null);
    }

    @Nonnull
    public ChatMessageRequestBuilder messages(@Nonnull String id) {
        return new ChatMessageRequestBuilder(this.getRequestUrlWithAdditionalSegment("messages") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public PinnedChatMessageInfoCollectionRequestBuilder pinnedMessages() {
        return new PinnedChatMessageInfoCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("pinnedMessages"), this.getClient(), null);
    }

    @Nonnull
    public PinnedChatMessageInfoRequestBuilder pinnedMessages(@Nonnull String id) {
        return new PinnedChatMessageInfoRequestBuilder(this.getRequestUrlWithAdditionalSegment("pinnedMessages") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public TeamsTabCollectionRequestBuilder tabs() {
        return new TeamsTabCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("tabs"), this.getClient(), null);
    }

    @Nonnull
    public TeamsTabRequestBuilder tabs(@Nonnull String id) {
        return new TeamsTabRequestBuilder(this.getRequestUrlWithAdditionalSegment("tabs") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public ChatSendActivityNotificationRequestBuilder sendActivityNotification(@Nonnull ChatSendActivityNotificationParameterSet parameters) {
        return new ChatSendActivityNotificationRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.sendActivityNotification"), this.getClient(), null, parameters);
    }
}

