/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config;

import com.azure.data.appconfiguration.ConfigurationClient;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.microsoft.azure.spring.cloud.config.AppConfigurationProperties;
import com.microsoft.azure.spring.cloud.config.AppConfigurationProviderProperties;
import com.microsoft.azure.spring.cloud.config.KeyVaultCredentialProvider;
import com.microsoft.azure.spring.cloud.config.SecretClientBuilderSetup;
import com.microsoft.azure.spring.cloud.config.feature.management.entity.Feature;
import com.microsoft.azure.spring.cloud.config.feature.management.entity.FeatureManagementItem;
import com.microsoft.azure.spring.cloud.config.feature.management.entity.FeatureSet;
import com.microsoft.azure.spring.cloud.config.stores.ClientStore;
import com.microsoft.azure.spring.cloud.config.stores.ConfigStore;
import com.microsoft.azure.spring.cloud.config.stores.KeyVaultClient;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.util.ReflectionUtils;

public class AppConfigurationPropertySource
extends EnumerablePropertySource<ConfigurationClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationPropertySource.class);
    private final String context;
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private final String label;
    private AppConfigurationProperties appConfigurationProperties;
    private static ObjectMapper mapper = new ObjectMapper();
    private HashMap<String, KeyVaultClient> keyVaultClients;
    private ClientStore clients;
    private KeyVaultCredentialProvider keyVaultCredentialProvider;
    private SecretClientBuilderSetup keyVaultClientProvider;
    private AppConfigurationProviderProperties appProperties;
    private ConfigStore configStore;

    AppConfigurationPropertySource(String context, ConfigStore configStore, String label, AppConfigurationProperties appConfigurationProperties, ClientStore clients, AppConfigurationProviderProperties appProperties, KeyVaultCredentialProvider keyVaultCredentialProvider, SecretClientBuilderSetup keyVaultClientProvider) {
        super(context + configStore.getEndpoint() + "/" + label);
        this.context = context;
        this.configStore = configStore;
        this.label = label;
        this.appConfigurationProperties = appConfigurationProperties;
        this.appProperties = appProperties;
        this.keyVaultClients = new HashMap();
        this.clients = clients;
        this.keyVaultCredentialProvider = keyVaultCredentialProvider;
        this.keyVaultClientProvider = keyVaultClientProvider;
    }

    public String[] getPropertyNames() {
        Set<String> keySet = this.properties.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    FeatureSet initProperties(FeatureSet featureSet) throws IOException {
        String storeName = this.configStore.getEndpoint();
        Date date = new Date();
        SettingSelector settingSelector = new SettingSelector().setLabelFilter(this.label);
        settingSelector.setKeyFilter(this.context + "*");
        List<ConfigurationSetting> settings = this.clients.listSettings(settingSelector, storeName);
        settingSelector.setKeyFilter(".appconfig*");
        List<ConfigurationSetting> features = this.clients.listSettings(settingSelector, storeName);
        if (settings == null || features == null) {
            throw new IOException("Unable to load properties from App Configuration Store.");
        }
        for (ConfigurationSetting setting : settings) {
            String key = setting.getKey().trim().substring(this.context.length()).replace('/', '.');
            if (setting.getContentType() != null && setting.getContentType().equals("application/vnd.microsoft.appconfig.keyvaultref+json;charset=utf-8")) {
                String entry = this.getKeyVaultEntry(setting.getValue());
                if (entry == null) continue;
                this.properties.put(key, entry);
                continue;
            }
            this.properties.put(key, setting.getValue());
        }
        return this.addToFeatureSet(featureSet, features, date);
    }

    private String getKeyVaultEntry(String value) {
        String secretValue = null;
        try {
            KeyVaultSecret secret;
            URI uri = null;
            try {
                JsonNode kvReference = mapper.readTree(value);
                uri = new URI(kvReference.at("/uri").asText());
            }
            catch (URISyntaxException e) {
                LOGGER.error("Error Processing Key Vault Entry URI.");
                ReflectionUtils.rethrowRuntimeException((Throwable)e);
            }
            if (!this.keyVaultClients.containsKey(uri.getHost())) {
                KeyVaultClient client = new KeyVaultClient(this.appConfigurationProperties, uri, this.keyVaultCredentialProvider, this.keyVaultClientProvider);
                this.keyVaultClients.put(uri.getHost(), client);
            }
            if ((secret = this.keyVaultClients.get(uri.getHost()).getSecret(uri, this.appProperties.getMaxRetryTime())) == null) {
                throw new IOException("No Key Vault Secret found for Reference.");
            }
            secretValue = secret.getValue();
        }
        catch (IOException | RuntimeException e) {
            LOGGER.error("Error Retreiving Key Vault Entry");
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
        return secretValue;
    }

    void initFeatures(FeatureSet featureSet) {
        ObjectMapper featureMapper = new ObjectMapper();
        featureMapper.setPropertyNamingStrategy(PropertyNamingStrategy.KEBAB_CASE);
        this.properties.put("feature-management.featureManagement", featureMapper.convertValue(featureSet.getFeatureManagement(), LinkedHashMap.class));
    }

    private FeatureSet addToFeatureSet(FeatureSet featureSet, List<ConfigurationSetting> settings, Date date) throws IOException {
        for (ConfigurationSetting setting : settings) {
            Object feature = this.createFeature(setting);
            if (feature == null) continue;
            featureSet.addFeature(setting.getKey().trim().substring(".appconfig.featureflag/".length()), feature);
        }
        return featureSet;
    }

    private Object createFeature(ConfigurationSetting item) throws IOException {
        Feature feature = null;
        if (item.getContentType() != null && item.getContentType().equals("application/vnd.microsoft.appconfig.ff+json;charset=utf-8")) {
            try {
                String key = item.getKey().trim().substring(".appconfig.featureflag/".length());
                FeatureManagementItem featureItem = (FeatureManagementItem)mapper.readValue(item.getValue(), FeatureManagementItem.class);
                feature = new Feature(key, featureItem);
                if (feature.getEnabledFor().size() == 0 && featureItem.getEnabled()) {
                    return true;
                }
                if (!featureItem.getEnabled()) {
                    return false;
                }
                return feature;
            }
            catch (IOException e) {
                throw new IOException("Unabled to parse Feature Management values from Azure.", e);
            }
        }
        String message = String.format("Found Feature Flag %s with invalid Content Type of %s", item.getKey(), item.getContentType());
        throw new IOException(message);
    }
}

