/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config;

import com.microsoft.azure.spring.cloud.config.AppConfigurationProperties;
import com.microsoft.azure.spring.cloud.config.AppConfigurationPropertySourceLocator;
import com.microsoft.azure.spring.cloud.config.AppConfigurationRefresh;
import com.microsoft.azure.spring.cloud.config.stores.ClientStore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.endpoint.RefreshEndpoint;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@ConditionalOnProperty(prefix="spring.cloud.azure.appconfiguration", name={"enabled"}, matchIfMissing=true)
@EnableAsync
public class AppConfigurationAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={RefreshEndpoint.class})
    static class AppConfigurationWatchAutoConfiguration {
        AppConfigurationWatchAutoConfiguration() {
        }

        @Bean
        public AppConfigurationRefresh getConfigWatch(AppConfigurationProperties properties, AppConfigurationPropertySourceLocator sourceLocator, ClientStore clientStore) {
            return new AppConfigurationRefresh(properties, sourceLocator.getStoreContextsMap(), clientStore);
        }
    }
}

