/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage.table;

import com.azure.data.tables.TableClient;
import com.azure.data.tables.TableServiceClient;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.storage.table.Table;
import com.microsoft.azure.toolkit.lib.storage.table.TableModule;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class TableDraft
extends Table
implements AzResource.Draft<Table, TableClient> {
    @Nullable
    private final Table origin;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    TableDraft(@Nonnull String name, @Nonnull TableModule module) {
        super(name, module);
        this.origin = null;
    }

    TableDraft(@Nonnull Table origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
    }

    @Nonnull
    @AzureOperation(name="azure/storage.create_table.table", params={"this.getName()"})
    public TableClient createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            TableModule module = (TableModule)this.getModule();
            TableServiceClient client = module.getTableServiceClient();
            IAzureMessager messager = AzureMessager.getMessager();
            messager.info(AzureString.format((String)"Start creating Table ({0}).", (Object[])new Object[]{this.getName()}));
            TableClient table = client.createTable(this.getName());
            messager.success(AzureString.format((String)"Table ({0}) is successfully created.", (Object[])new Object[]{this.getName()}));
            TableClient tableClient = table;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return tableClient;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="azure/storage.update_table.table", params={"this.getName()"})
    public TableClient updateResourceInAzure(@Nonnull TableClient origin) {
        TableClient tableClient = origin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)tableClient);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            throw new AzureToolkitRuntimeException("not supported");
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public boolean isModified() {
        return false;
    }

    @Nullable
    @Generated
    public Table getOrigin() {
        return this.origin;
    }

    static {
        TableDraft.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TableDraft.java", TableDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.storage.table.TableDraft", "", "", "", "com.azure.data.tables.TableClient"), 45);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.storage.table.TableDraft", "com.azure.data.tables.TableClient", "origin", "", "com.azure.data.tables.TableClient"), 58);
    }
}

