/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage.share;

import com.azure.storage.file.share.ShareClient;
import com.azure.storage.file.share.ShareServiceClient;
import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.action.AzureActionManager;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.storage.IStorageAccount;
import com.microsoft.azure.toolkit.lib.storage.share.Share;
import com.microsoft.azure.toolkit.lib.storage.share.ShareModule;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ShareDraft
extends Share
implements AzResource.Draft<Share, ShareClient> {
    @Nullable
    private final Share origin;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    ShareDraft(@Nonnull String name, @Nonnull ShareModule module) {
        super(name, module);
        this.origin = null;
    }

    ShareDraft(@Nonnull Share origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
    }

    @Nonnull
    @AzureOperation(name="azure/storage.create_share.share", params={"this.getName()"})
    public ShareClient createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ShareModule module = (ShareModule)this.getModule();
            ShareServiceClient client = module.getFileShareServiceClient();
            if (Objects.isNull(client)) {
                throw new AzureToolkitRuntimeException(String.format("Failed to create Share (%s) because storage Account (%s) doesn't exist.", this.getName(), ((IStorageAccount)module.getParent()).getName()));
            }
            IAzureMessager messager = AzureMessager.getMessager();
            messager.info(AzureString.format((String)"Start creating File Share ({0}).", (Object[])new Object[]{this.getName()}));
            ShareClient share = client.createShare(this.getName());
            Action createFile = AzureActionManager.getInstance().getAction(CREATE_FILE).bind((Object)this);
            Action createDir = AzureActionManager.getInstance().getAction(CREATE_DIRECTORY).bind((Object)this);
            Action upload = AzureActionManager.getInstance().getAction(UPLOAD_FILES).bind((Object)this);
            messager.success(AzureString.format((String)"File Share ({0}) is successfully created.", (Object[])new Object[]{this.getName()}), new Object[]{createFile, createDir, upload});
            ShareClient shareClient = share;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return shareClient;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="azure/storage.update_share.share", params={"this.getName()"})
    public ShareClient updateResourceInAzure(@Nonnull ShareClient origin) {
        ShareClient shareClient = origin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)shareClient);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            throw new AzureToolkitRuntimeException("not supported");
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public boolean isModified() {
        return false;
    }

    @Nullable
    @Generated
    public Share getOrigin() {
        return this.origin;
    }

    static {
        ShareDraft.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ShareDraft.java", ShareDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.storage.share.ShareDraft", "", "", "", "com.azure.storage.file.share.ShareClient"), 49);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.storage.share.ShareDraft", "com.azure.storage.file.share.ShareClient", "origin", "", "com.azure.storage.file.share.ShareClient"), 68);
    }
}

