/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage.model;

import com.google.common.collect.ImmutableList;
import com.microsoft.azure.toolkit.lib.common.model.ExpandableParameter;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class Performance
implements ExpandableParameter {
    public static final Performance STANDARD = new Performance("Standard", "Recommended for most scenarios (general-purpose v2 account)");
    public static final Performance PREMIUM = new Performance("Premium", "Recommended for scenarios that require low latency");
    private static final List<Performance> values = new ImmutableList.Builder().add((Object[])new Performance[]{STANDARD, PREMIUM}).build();
    private final String name;
    private final String label;

    private Performance(String name, String label) {
        this.name = name;
        this.label = label;
    }

    public static List<Performance> values() {
        return values;
    }

    @Nonnull
    public static Performance fromName(@Nonnull String value) {
        return Performance.values().stream().filter(region -> StringUtils.equalsAnyIgnoreCase((CharSequence)value, (CharSequence[])new CharSequence[]{region.name, region.label})).findFirst().orElse(new Performance(value, value));
    }

    public boolean isExpandedValue() {
        return !Performance.values().contains(this);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Performance)) {
            return false;
        }
        Performance other = (Performance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        return !(this$label == null ? other$label != null : !this$label.equals(other$label));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Performance;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        return result;
    }
}

