/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage.blob;

import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.action.AzureActionManager;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.storage.IStorageAccount;
import com.microsoft.azure.toolkit.lib.storage.blob.BlobContainer;
import com.microsoft.azure.toolkit.lib.storage.blob.BlobContainerModule;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class BlobContainerDraft
extends BlobContainer
implements AzResource.Draft<BlobContainer, BlobContainerClient> {
    @Nullable
    private final BlobContainer origin;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    BlobContainerDraft(@Nonnull String name, @Nonnull BlobContainerModule module) {
        super(name, module);
        this.origin = null;
    }

    BlobContainerDraft(@Nonnull BlobContainer origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
    }

    @Nonnull
    @AzureOperation(name="azure/storage.create_blob_container.container", params={"this.getName()"})
    public BlobContainerClient createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            BlobContainerModule module = (BlobContainerModule)this.getModule();
            BlobServiceClient client = module.getBlobServiceClient();
            if (Objects.isNull(client)) {
                throw new AzureToolkitRuntimeException(String.format("Failed to create Blob Container (%s) because storage account (%s) doesn't exist.", this.getName(), ((IStorageAccount)module.getParent()).getName()));
            }
            IAzureMessager messager = AzureMessager.getMessager();
            messager.info(AzureString.format((String)"Start creating Blob Container ({0}).", (Object[])new Object[]{this.getName()}));
            BlobContainerClient container = client.createBlobContainer(this.getName());
            Action create = Optional.ofNullable(AzureActionManager.getInstance().getAction(CREATE_BLOB)).map(action -> action.bind((Object)this)).orElse(null);
            Action upload = Optional.ofNullable(AzureActionManager.getInstance().getAction(UPLOAD_FILES)).map(action -> action.bind((Object)this)).orElse(null);
            messager.success(AzureString.format((String)"Blob Container ({0}) is successfully created.", (Object[])new Object[]{this.getName()}), new Object[]{create, upload});
            BlobContainerClient blobContainerClient = container;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return blobContainerClient;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="azure/storage.update_blob_container.container", params={"this.getName()"})
    public BlobContainerClient updateResourceInAzure(@Nonnull BlobContainerClient origin) {
        BlobContainerClient blobContainerClient = origin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)blobContainerClient);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            throw new AzureToolkitRuntimeException("not supported");
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public boolean isModified() {
        return false;
    }

    @Nullable
    @Generated
    public BlobContainer getOrigin() {
        return this.origin;
    }

    static {
        BlobContainerDraft.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BlobContainerDraft.java", BlobContainerDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.storage.blob.BlobContainerDraft", "", "", "", "com.azure.storage.blob.BlobContainerClient"), 50);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.storage.blob.BlobContainerDraft", "com.azure.storage.blob.BlobContainerClient", "origin", "", "com.azure.storage.blob.BlobContainerClient"), 70);
    }
}

