/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage;

import com.azure.core.management.AzureEnvironment;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.storage.fluent.models.StorageAccountInner;
import com.azure.resourcemanager.storage.models.StorageAccountKey;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.auth.AzureCloud;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AbstractEmulatableAzResource;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.storage.StorageAccountModule;
import com.microsoft.azure.toolkit.lib.storage.StorageServiceSubscription;
import com.microsoft.azure.toolkit.lib.storage.blob.BlobContainerModule;
import com.microsoft.azure.toolkit.lib.storage.model.AccessTier;
import com.microsoft.azure.toolkit.lib.storage.model.Kind;
import com.microsoft.azure.toolkit.lib.storage.model.Performance;
import com.microsoft.azure.toolkit.lib.storage.model.Redundancy;
import com.microsoft.azure.toolkit.lib.storage.queue.QueueModule;
import com.microsoft.azure.toolkit.lib.storage.share.ShareModule;
import com.microsoft.azure.toolkit.lib.storage.table.TableModule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class StorageAccount
extends AbstractEmulatableAzResource<StorageAccount, StorageServiceSubscription, com.azure.resourcemanager.storage.models.StorageAccount>
implements Deletable {
    protected final BlobContainerModule blobContainerModule;
    protected final ShareModule shareModule;
    protected final QueueModule queueModule;
    protected final TableModule tableModule;
    protected final List<AbstractAzResourceModule<?, ?, ?>> subModules = new ArrayList();

    protected StorageAccount(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull StorageAccountModule module) {
        super(name, resourceGroupName, (AbstractAzResourceModule)module);
        this.blobContainerModule = new BlobContainerModule(this);
        this.shareModule = new ShareModule(this);
        this.queueModule = new QueueModule(this);
        this.tableModule = new TableModule(this);
    }

    public StorageAccount(@Nonnull StorageAccount origin) {
        super((AbstractAzResource)origin);
        this.shareModule = origin.shareModule;
        this.blobContainerModule = origin.blobContainerModule;
        this.queueModule = origin.queueModule;
        this.tableModule = origin.tableModule;
    }

    protected StorageAccount(@Nonnull com.azure.resourcemanager.storage.models.StorageAccount remote, @Nonnull StorageAccountModule module) {
        super(remote.name(), remote.resourceGroupName(), (AbstractAzResourceModule)module);
        this.blobContainerModule = new BlobContainerModule(this);
        this.shareModule = new ShareModule(this);
        this.queueModule = new QueueModule(this);
        this.tableModule = new TableModule(this);
    }

    @Nonnull
    public synchronized List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        if (!this.subModules.isEmpty()) {
            return this.subModules;
        }
        if (this.canHaveBlobs()) {
            this.subModules.add((AbstractAzResourceModule<?, ?, ?>)this.blobContainerModule);
        }
        if (this.canHaveShares()) {
            this.subModules.add((AbstractAzResourceModule<?, ?, ?>)this.shareModule);
        }
        if (this.canHaveQueues()) {
            this.subModules.add((AbstractAzResourceModule<?, ?, ?>)this.queueModule);
        }
        if (this.canHaveTables()) {
            this.subModules.add((AbstractAzResourceModule<?, ?, ?>)this.tableModule);
        }
        return this.subModules;
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getCachedSubModules() {
        return this.subModules;
    }

    @Nonnull
    protected String loadStatus(@Nonnull com.azure.resourcemanager.storage.models.StorageAccount remote) {
        return ((StorageAccountInner)remote.innerModel()).provisioningState().toString();
    }

    @Nonnull
    public String getConnectionString() {
        AzureEnvironment environment = ((AzureCloud)Azure.az(AzureCloud.class)).get();
        return ResourceManagerUtils.getStorageConnectionString((String)this.getName(), (String)this.getKey(), (AzureEnvironment)environment);
    }

    @Nonnull
    public String getKey() {
        com.azure.resourcemanager.storage.models.StorageAccount remote = (com.azure.resourcemanager.storage.models.StorageAccount)this.getRemote();
        if (Objects.isNull(remote)) {
            throw new AzureToolkitRuntimeException(String.format("Storage Account(%s) doesn't exist.", this.getName()));
        }
        return Objects.requireNonNull(((StorageAccountKey)remote.getKeys().get(0)).value());
    }

    @Nullable
    public Region getRegion() {
        return this.remoteOptional().map(remote -> Region.fromName((String)remote.regionName())).orElse(null);
    }

    @Nullable
    public Performance getPerformance() {
        return this.remoteOptional().map(remote -> {
            String[] replicationArr = remote.skuType().name().toString().split("_");
            return replicationArr.length == 2 ? Performance.fromName(replicationArr[0]) : null;
        }).orElse(null);
    }

    public boolean canHaveQueues() {
        return this.remoteOptional().map(remote -> StringUtils.isNotBlank((CharSequence)((StorageAccountInner)remote.innerModel()).primaryEndpoints().queue())).orElse(false);
    }

    public boolean canHaveTables() {
        return this.remoteOptional().map(remote -> StringUtils.isNotBlank((CharSequence)((StorageAccountInner)remote.innerModel()).primaryEndpoints().table())).orElse(false);
    }

    public boolean canHaveBlobs() {
        return this.remoteOptional().map(remote -> StringUtils.isNotBlank((CharSequence)((StorageAccountInner)remote.innerModel()).primaryEndpoints().blob())).orElse(false);
    }

    public boolean canHaveShares() {
        return this.remoteOptional().map(remote -> StringUtils.isNotBlank((CharSequence)((StorageAccountInner)remote.innerModel()).primaryEndpoints().file())).orElse(false);
    }

    @Nullable
    public Redundancy getRedundancy() {
        return this.remoteOptional().map(remote -> Redundancy.fromName(remote.skuType().name().toString())).orElse(null);
    }

    @Nullable
    public Kind getKind() {
        return this.remoteOptional().map(remote -> Kind.fromName(remote.kind().toString())).orElse(null);
    }

    @Nullable
    public AccessTier getAccessTier() {
        return this.remoteOptional().map(remote -> AccessTier.valueOf(remote.accessTier().name())).orElse(null);
    }

    public BlobContainerModule getBlobContainerModule() {
        return this.blobContainerModule;
    }

    public ShareModule getShareModule() {
        return this.shareModule;
    }

    public QueueModule getQueueModule() {
        return this.queueModule;
    }

    public TableModule getTableModule() {
        return this.tableModule;
    }
}

