/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud.task;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import com.microsoft.azure.toolkit.lib.containerapps.AzureContainerApps;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironment;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironmentDraft;
import com.microsoft.azure.toolkit.lib.resource.AzureResources;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupDraft;
import com.microsoft.azure.toolkit.lib.springcloud.AzureSpringCloud;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudAppDraft;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudCluster;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudClusterDraft;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentDraft;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudAppConfig;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudClusterConfig;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudDeploymentConfig;
import com.microsoft.azure.toolkit.lib.springcloud.model.Sku;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import reactor.core.Disposable;

public class DeploySpringCloudAppTask
extends AzureTask<SpringCloudDeployment> {
    public static final String DEFAULT_DEPLOYMENT_NAME = "default";
    private final SpringCloudAppConfig config;
    @Nonnull
    private final List<AzureTask<?>> subTasks;
    private SpringCloudDeployment deployment;
    private final boolean openStreamingLogOnFailure;
    private final boolean waitDeploymentComplete;
    private static final int TIMEOUT_IN_SECONDS = 60;
    private static final String GET_APP_STATUS_TIMEOUT = "Deployment succeeded but the app is still starting, you can check the app status from Azure Portal.";
    private static final String START_APP = "Starting Spring App after deploying artifacts...";
    private Disposable disposable;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public DeploySpringCloudAppTask(SpringCloudAppConfig appConfig) {
        this(appConfig, false, false);
    }

    public DeploySpringCloudAppTask(SpringCloudAppConfig appConfig, boolean openStreamingLogOnFailure, boolean waitDeploymentComplete) {
        this.config = appConfig;
        this.subTasks = new ArrayList();
        this.openStreamingLogOnFailure = openStreamingLogOnFailure;
        this.waitDeploymentComplete = waitDeploymentComplete;
        this.initTasks();
    }

    private void initTasks() {
        AzureString MODIFY_DEPLOYMENT_TITLE;
        SpringCloudDeploymentConfig deploymentConfig = this.config.getDeployment();
        SpringCloudClusterConfig clusterConfig = this.config.getCluster();
        String subscriptionId = Optional.ofNullable(clusterConfig).map(SpringCloudClusterConfig::getSubscriptionId).filter(StringUtils::isNotBlank).orElseThrow(() -> new AzureToolkitRuntimeException("'subscriptionId' is required"));
        String clusterName = Optional.ofNullable(this.config.getCluster()).map(SpringCloudClusterConfig::getClusterName).filter(StringUtils::isNotBlank).orElseThrow(() -> new AzureToolkitRuntimeException("'clusterName' is required"));
        String appName = Optional.ofNullable(this.config.getAppName()).filter(StringUtils::isNotBlank).orElseThrow(() -> new AzureToolkitRuntimeException("'appName' is required"));
        String resourceGroup = Optional.of(clusterConfig).map(SpringCloudClusterConfig::getResourceGroup).orElse(null);
        SpringCloudCluster cluster = ((AzureSpringCloud)Azure.az(AzureSpringCloud.class)).clusters(subscriptionId).get(clusterName, resourceGroup);
        if (Objects.isNull((Object)cluster)) {
            cluster = (SpringCloudCluster)((AzureSpringCloud)Azure.az(AzureSpringCloud.class)).clusters(subscriptionId).create(clusterName, resourceGroup);
        }
        SpringCloudAppDraft app = (SpringCloudAppDraft)cluster.apps().updateOrCreate(appName, resourceGroup);
        String deploymentName = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{deploymentConfig.getDeploymentName(), this.config.getActiveDeploymentName(), app.getActiveDeploymentName(), DEFAULT_DEPLOYMENT_NAME});
        boolean toCreateCluster = cluster.isDraftForCreating() && !cluster.exists();
        boolean toCreateApp = !app.exists();
        boolean toCreateDeployment = toCreateApp || !app.deployments().exists(deploymentName, resourceGroup);
        this.config.setActiveDeploymentName((String)StringUtils.firstNonBlank((CharSequence[])new String[]{app.getActiveDeploymentName(), toCreateApp || toCreateDeployment ? deploymentName : null}));
        OperationContext.action().setTelemetryProperty("subscriptionId", subscriptionId);
        OperationContext.current().setTelemetryProperty("isCreateNewApp", String.valueOf(toCreateApp));
        OperationContext.current().setTelemetryProperty("isCreateDeployment", String.valueOf(toCreateApp || toCreateDeployment));
        OperationContext.current().setTelemetryProperty("isDeploymentNameGiven", String.valueOf(StringUtils.isNotEmpty((CharSequence)deploymentConfig.getDeploymentName())));
        AzureString CREATE_APP_TITLE = AzureString.format((String)"Create new app({0}) and deployment({1}) in Azure Spring Apps({2})", (Object[])new Object[]{appName, deploymentName, clusterName});
        AzureString UPDATE_APP_TITLE = AzureString.format((String)"Update app({0}) of Azure Spring Apps({1})", (Object[])new Object[]{appName, clusterName});
        AzureString CREATE_DEPLOYMENT_TITLE = AzureString.format((String)"Create new deployment({0}) in app({1})", (Object[])new Object[]{deploymentName, appName});
        AzureString UPDATE_DEPLOYMENT_TITLE = AzureString.format((String)"Update deployment({0}) of app({1})", (Object[])new Object[]{deploymentName, appName});
        AzureString azureString = MODIFY_DEPLOYMENT_TITLE = toCreateDeployment ? CREATE_DEPLOYMENT_TITLE : UPDATE_DEPLOYMENT_TITLE;
        if (toCreateCluster) {
            this.addCreateClusterTask(cluster);
        }
        app.setConfig(this.config);
        if (toCreateApp) {
            this.subTasks.add(new AzureTask(CREATE_APP_TITLE, () -> ((SpringCloudAppDraft)app).createIfNotExist()));
        }
        this.subTasks.add(new AzureTask(MODIFY_DEPLOYMENT_TITLE, () -> {
            SpringCloudDeploymentDraft draft = (SpringCloudDeploymentDraft)app.deployments().updateOrCreate(deploymentName, resourceGroup);
            draft.setConfig(this.config.getDeployment());
            try {
                this.deployment = (SpringCloudDeployment)draft.commit();
            }
            catch (Exception e) {
                app.refresh();
                this.deployment = app.getActiveDeployment();
                Optional.ofNullable(this.deployment).ifPresent(d -> d.startStreamingLog(true));
                throw new AzureToolkitRuntimeException((Throwable)e);
            }
        }));
        this.subTasks.add(new AzureTask(UPDATE_APP_TITLE, () -> {
            SpringCloudAppDraft draft = (SpringCloudAppDraft)app.update();
            draft.setConfig(this.config);
            draft.updateIfExist();
            app.refresh();
        }));
        this.subTasks.add(new AzureTask(app::reset));
        if (this.waitDeploymentComplete) {
            this.subTasks.add(new AzureTask(this::startApp));
        }
    }

    private void addCreateClusterTask(SpringCloudCluster cluster) {
        Optional.ofNullable(this.config.getResourceGroup()).filter(StringUtils::isNotBlank).orElseThrow(() -> new AzureToolkitRuntimeException("'resourceGroup' is required to create Azure Spring Apps"));
        Optional.ofNullable(this.config.getCluster()).map(SpringCloudClusterConfig::getRegion).filter(StringUtils::isNotBlank).orElseThrow(() -> new AzureToolkitRuntimeException("'region' is required to create Azure Spring Apps"));
        Optional.ofNullable(this.config.getCluster()).map(SpringCloudClusterConfig::getSku).filter(StringUtils::isNotBlank).orElseThrow(() -> new AzureToolkitRuntimeException("'sku' is required to create Azure Spring Apps"));
        SpringCloudClusterConfig clusterConfig = this.config.getCluster();
        this.addCreateResourceGroupTaskIfNecessary(clusterConfig);
        this.addCreateEnvironmentTaskIfNecessary(clusterConfig);
        AzureString CREATE_CLUSTER_TITLE = AzureString.format((String)"Create new Azure Spring Apps({0})", (Object[])new Object[]{clusterConfig.getClusterName()});
        this.subTasks.add(new AzureTask(CREATE_CLUSTER_TITLE, () -> {
            SpringCloudClusterDraft draft = (SpringCloudClusterDraft)cluster;
            SpringCloudClusterDraft.Config config = DeploySpringCloudAppTask.getDraftConfig(this.config.getCluster());
            draft.setConfig(config);
            draft.createIfNotExist();
        }));
    }

    private void addCreateResourceGroupTaskIfNecessary(@Nonnull SpringCloudClusterConfig config) {
        ResourceGroup resourceGroup = (ResourceGroup)((AzureResources)Azure.az(AzureResources.class)).groups(config.getSubscriptionId()).getOrDraft(config.getResourceGroup(), config.getResourceGroup());
        if (resourceGroup.isDraftForCreating() && !resourceGroup.exists()) {
            AzureString title = AzureString.format((String)"Create new resource group ({0})", (Object[])new Object[]{config.getResourceGroup()});
            ResourceGroupDraft draft = (ResourceGroupDraft)resourceGroup;
            draft.setRegion(Region.fromName((String)config.getRegion()));
            this.subTasks.add(new AzureTask(title, () -> ((ResourceGroupDraft)draft).commit()));
        }
    }

    private void addCreateEnvironmentTaskIfNecessary(@Nonnull SpringCloudClusterConfig clusterConfig) {
        Sku sku = Sku.fromString(this.config.getCluster().getSku());
        if (!sku.isConsumptionTier()) {
            return;
        }
        String env = Optional.ofNullable(this.config.getCluster()).map(SpringCloudClusterConfig::getEnvironment).filter(StringUtils::isNotBlank).orElseThrow(() -> new AzureToolkitRuntimeException("'environment' is required to create Azure Spring Apps"));
        ContainerAppsEnvironment environment = (ContainerAppsEnvironment)((AzureContainerApps)Azure.az(AzureContainerApps.class)).environments(clusterConfig.getSubscriptionId()).getOrDraft(env, (String)StringUtils.firstNonBlank((CharSequence[])new String[]{clusterConfig.getEnvironmentResourceGroup(), clusterConfig.getResourceGroup()}));
        AzureString title = AzureString.format((String)"Create new Container Apps Environment({0})", (Object[])new Object[]{environment.getName()});
        if (environment.isDraftForCreating() && !environment.exists()) {
            this.subTasks.add(new AzureTask(title, () -> {
                ResourceGroup resourceGroup = (ResourceGroup)((AzureResources)Azure.az(AzureResources.class)).groups(this.config.getSubscriptionId()).get(this.config.getResourceGroup(), this.config.getResourceGroup());
                ContainerAppsEnvironmentDraft draft = (ContainerAppsEnvironmentDraft)environment;
                ContainerAppsEnvironmentDraft.Config config = new ContainerAppsEnvironmentDraft.Config();
                config.setName(draft.getName());
                config.setResourceGroup(resourceGroup);
                config.setRegion(Region.fromName((String)clusterConfig.getRegion()));
                draft.setConfig(config);
                draft.commit();
            }));
        }
    }

    private static SpringCloudClusterDraft.Config getDraftConfig(@Nonnull SpringCloudClusterConfig cluster) {
        SpringCloudClusterDraft.Config result = new SpringCloudClusterDraft.Config();
        ResourceGroup resourceGroup = (ResourceGroup)((AzureResources)Azure.az(AzureResources.class)).groups(cluster.getSubscriptionId()).get(cluster.getResourceGroup(), cluster.getResourceGroup());
        Sku sku = Sku.fromString(cluster.getSku());
        result.setName(cluster.getClusterName());
        result.setResourceGroup(resourceGroup);
        result.setRegion(com.azure.core.management.Region.fromName((String)cluster.getRegion()));
        result.setSku(sku);
        if (sku.isConsumptionTier()) {
            ContainerAppsEnvironment environment = (ContainerAppsEnvironment)((AzureContainerApps)Azure.az(AzureContainerApps.class)).environments(cluster.getSubscriptionId()).get(cluster.getEnvironment(), (String)StringUtils.firstNonBlank((CharSequence[])new String[]{cluster.getEnvironmentResourceGroup(), cluster.getResourceGroup()}));
            result.setManagedEnvironmentId(Objects.requireNonNull(environment).getId());
        }
        return result;
    }

    @AzureOperation(name="internal/springcloud.create_update_app.app", params={"this.config.getAppName()"})
    public SpringCloudDeployment doExecute() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            for (AzureTask<?> t : this.subTasks) {
                t.getBody().call();
            }
            SpringCloudDeployment springCloudDeployment = this.deployment;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return springCloudDeployment;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private void startApp() {
        AzureMessager.getMessager().info(START_APP);
        if (!this.deployment.waitUntilReady(60)) {
            AzureMessager.getMessager().warning(GET_APP_STATUS_TIMEOUT);
            Optional.ofNullable(this.deployment).ifPresent(d -> d.startStreamingLog(false));
        }
    }

    public SpringCloudAppConfig getConfig() {
        return this.config;
    }

    @Nonnull
    public List<AzureTask<?>> getSubTasks() {
        return this.subTasks;
    }

    public SpringCloudDeployment getDeployment() {
        return this.deployment;
    }

    public boolean isOpenStreamingLogOnFailure() {
        return this.openStreamingLogOnFailure;
    }

    public boolean isWaitDeploymentComplete() {
        return this.waitDeploymentComplete;
    }

    public Disposable getDisposable() {
        return this.disposable;
    }

    static {
        DeploySpringCloudAppTask.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DeploySpringCloudAppTask.java", DeploySpringCloudAppTask.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "doExecute", "com.microsoft.azure.toolkit.lib.springcloud.task.DeploySpringCloudAppTask", "", "", "java.lang.Exception", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment"), 211);
    }
}

