/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.resourcemanager.appplatform.fluent.models.DeploymentResourceInner;
import com.azure.resourcemanager.appplatform.implementation.SpringAppDeploymentImpl;
import com.azure.resourcemanager.appplatform.implementation.SpringAppImpl;
import com.azure.resourcemanager.appplatform.implementation.SpringServiceImpl;
import com.azure.resourcemanager.appplatform.models.DeploymentResourceProperties;
import com.azure.resourcemanager.appplatform.models.DeploymentSettings;
import com.azure.resourcemanager.appplatform.models.RuntimeVersion;
import com.azure.resourcemanager.appplatform.models.Scale;
import com.azure.resourcemanager.appplatform.models.SpringApp;
import com.azure.resourcemanager.appplatform.models.SpringAppDeployment;
import com.azure.resourcemanager.appplatform.models.UserSourceType;
import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.action.AzureActionManager;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.IArtifact;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskManager;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudCluster;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentModule;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudDeploymentConfig;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringCloudDeploymentDraft
extends SpringCloudDeployment
implements AzResource.Draft<SpringCloudDeployment, SpringAppDeployment>,
InvocationHandler {
    private static final Logger log;
    public static final RuntimeVersion DEFAULT_RUNTIME_VERSION;
    public static final double DEFAULT_MEMORY = 2.0;
    public static final double DEFAULT_CPU = 1.0;
    public static final int DEFAULT_CAPACITY = 1;
    private static final String RUNTIME_VERSION_PATTERN = "[Jj]ava((\\s)?|_)(8|11|17)$";
    @Nonnull
    private final IConfig configProxy;
    @Nullable
    private final SpringCloudDeployment origin;
    @Nullable
    private Config config;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    protected SpringCloudDeploymentDraft(@Nonnull String name, @Nonnull SpringCloudDeploymentModule module) {
        super(name, module);
        this.origin = null;
        this.withDefaultConfig();
        this.configProxy = (IConfig)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IConfig.class}, (InvocationHandler)this);
    }

    protected SpringCloudDeploymentDraft(@Nonnull SpringCloudDeployment origin) {
        super(origin);
        this.origin = origin;
        this.configProxy = (IConfig)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IConfig.class}, (InvocationHandler)this);
    }

    public void setConfig(@Nonnull SpringCloudDeploymentConfig deploymentConfig) {
        this.setCpu(deploymentConfig.getCpu());
        this.setMemoryInGB(deploymentConfig.getMemoryInGB());
        this.setCapacity(deploymentConfig.getCapacity());
        this.setEnvironmentVariables(deploymentConfig.getEnvironment());
        this.setRuntimeVersion(deploymentConfig.getRuntimeVersion());
        this.setJvmOptions(deploymentConfig.getJvmOptions());
        this.setArtifact(deploymentConfig.getArtifact());
    }

    public void withDefaultConfig() {
        this.config = new Config();
        this.config.setCapacity(1);
        this.config.setCpu(1.0);
        this.config.setMemoryInGB(2.0);
    }

    @Nonnull
    public SpringCloudDeploymentConfig getConfig() {
        return SpringCloudDeploymentConfig.builder().deploymentName(this.getName()).cpu(this.getCpu()).memoryInGB(this.getMemoryInGB()).capacity(this.getCapacity()).jvmOptions(this.getJvmOptions()).runtimeVersion(this.getRuntimeVersion()).environment(this.getEnvironmentVariables()).artifact(this.getArtifact()).build();
    }

    public void reset() {
        this.config = null;
    }

    @Nonnull
    @AzureOperation(name="azure/springcloud.create_app_deployment.deployment", params={"this.getName()"})
    public SpringAppDeployment createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            String name = this.getName();
            SpringApp app = (SpringApp)Objects.requireNonNull(((SpringCloudApp)this.getParent()).getRemote());
            SpringAppDeploymentImpl create = (SpringAppDeploymentImpl)((SpringAppDeployment.DefinitionStages.WithCreate)((SpringAppDeployment.DefinitionStages.Blank)app.deployments().define(name)).withExistingSource(UserSourceType.JAR, "<default>")).withActivation();
            this.updateScalingProperties(create);
            this.updateProperties(create);
            this.updateDeployingProperties(create);
            IAzureMessager messager = AzureMessager.getMessager();
            messager.info(AzureString.format((String)"Start creating deployment({0})...", (Object[])new Object[]{name}));
            SpringAppDeployment deployment = (SpringAppDeployment)create.create();
            Action deploy = AzureActionManager.getInstance().getAction(AzResource.DEPLOY).bind((Object)this.getParent());
            messager.success(AzureString.format((String)"Deployment({0}) is successfully created", (Object[])new Object[]{name}), new Object[]{deploy});
            AzureTaskManager.getInstance().runOnPooledThread(() -> ((SpringCloudApp)this.getParent()).refresh());
            SpringAppDeployment springAppDeployment = Objects.requireNonNull(deployment);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return springAppDeployment;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="azure/springcloud.update_app_deployment.deployment", params={"this.getName()"})
    public SpringAppDeployment updateResourceInAzure(@Nonnull SpringAppDeployment deployment) {
        SpringAppDeployment springAppDeployment = deployment;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)springAppDeployment);
        try {
            IAzureMessager messager;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            SpringAppDeploymentImpl update = (SpringAppDeploymentImpl)deployment.update();
            if (this.updateProperties(update)) {
                messager = AzureMessager.getMessager();
                messager.info(AzureString.format((String)"Start updating deployment({0})...", (Object[])new Object[]{deployment.name()}));
                deployment = (SpringAppDeployment)update.apply();
                messager.success(AzureString.format((String)"Deployment({0}) is successfully updated.", (Object[])new Object[]{deployment.name()}));
            }
            if (this.updateScalingProperties(update = (SpringAppDeploymentImpl)deployment.update())) {
                messager = AzureMessager.getMessager();
                messager.info(AzureString.format((String)"Start scaling deployment({0})...", (Object[])new Object[]{deployment.name()}));
                deployment = (SpringAppDeployment)update.apply();
                messager.success(AzureString.format((String)"Deployment({0}) is successfully scaled.", (Object[])new Object[]{deployment.name()}));
            }
            if (this.updateDeployingProperties(update = (SpringAppDeploymentImpl)deployment.update())) {
                messager = AzureMessager.getMessager();
                File artifact = Objects.requireNonNull(Objects.requireNonNull(Objects.requireNonNull(this.config).artifact).getFile());
                messager.info(AzureString.format((String)"Start deploying artifact(%s) to deployment(%s) of app(%s)...", (Object[])new Object[]{artifact.getName(), deployment.name(), ((SpringApp)deployment.parent()).name()}));
                deployment = (SpringAppDeployment)update.apply();
                Action openPublicUrl = AzureActionManager.getInstance().getAction(SpringCloudApp.OPEN_PUBLIC_URL).bind((Object)this.getParent());
                Action openTestUrl = AzureActionManager.getInstance().getAction(SpringCloudApp.OPEN_TEST_URL).bind((Object)this.getParent());
                messager.success(AzureString.format((String)"Artifact(%s) is successfully deployed to deployment(%s) of app(%s).", (Object[])new Object[]{artifact.getName(), deployment.name(), ((SpringApp)deployment.parent()).name()}), new Object[]{openPublicUrl, openTestUrl});
            }
            this.getSubModules().forEach(AbstractAzResourceModule::refresh);
            SpringAppDeployment springAppDeployment2 = deployment;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return springAppDeployment2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    boolean updateScalingProperties(@Nonnull SpringAppDeploymentImpl deployment) {
        boolean scaled = this.toScale();
        if (scaled) {
            Double newCpu = this.getCpu();
            Double newMemoryInGB = this.getMemoryInGB();
            Integer newCapacity = this.getCapacity();
            Optional.ofNullable(newCpu).ifPresent(arg_0 -> ((SpringAppDeploymentImpl)deployment).withCpu(arg_0));
            Optional.ofNullable(newMemoryInGB).ifPresent(arg_0 -> ((SpringAppDeploymentImpl)deployment).withMemory(arg_0));
            if (Objects.nonNull(newCapacity)) {
                if (((SpringCloudCluster)((SpringCloudApp)this.getParent()).getParent()).isConsumptionTier()) {
                    Integer max = Optional.ofNullable(deployment.innerModel()).map(DeploymentResourceInner::properties).map(DeploymentResourceProperties::deploymentSettings).map(DeploymentSettings::scale).map(Scale::maxReplicas).orElse(0);
                    if (!Objects.equals(newCapacity, max)) {
                        ((DeploymentResourceInner)deployment.innerModel()).properties().deploymentSettings().withScale(new Scale().withMaxReplicas(newCapacity));
                    }
                } else if (!Objects.equals(((SpringServiceImpl)((SpringAppImpl)deployment.parent()).parent()).sku().capacity(), newCapacity)) {
                    Optional.of(newCapacity).ifPresent(arg_0 -> ((SpringAppDeploymentImpl)deployment).withInstance(arg_0));
                }
            }
        }
        return scaled;
    }

    boolean updateProperties(@Nonnull SpringAppDeploymentImpl deployment) {
        boolean updated = this.toUpdate();
        if (updated) {
            Map<String, String> newEnv = this.getEnvironmentVariables();
            String newJvmOptions = this.getJvmOptions();
            String newVersion = this.getRuntimeVersion();
            Map oldEnv = (Map)Utils.emptyToNull(super.getEnvironmentVariables());
            if (Objects.nonNull(newEnv)) {
                Optional.ofNullable(oldEnv).ifPresent(e -> new HashSet(e.keySet()).forEach(arg_0 -> ((SpringAppDeploymentImpl)deployment).withoutEnvironment(arg_0)));
                Optional.of(newEnv).ifPresent(e -> e.forEach((arg_0, arg_1) -> ((SpringAppDeploymentImpl)deployment).withEnvironment(arg_0, arg_1)));
            }
            Optional.ofNullable(newJvmOptions).ifPresent(arg_0 -> ((SpringAppDeploymentImpl)deployment).withJvmOptions(arg_0));
            Optional.ofNullable(newVersion).ifPresent(v -> deployment.withRuntime(SpringCloudDeploymentDraft.formalizeRuntimeVersion(v)));
        }
        return updated;
    }

    boolean updateDeployingProperties(@Nonnull SpringAppDeploymentImpl deployment) {
        boolean toDeploy = this.toDeploy();
        if (toDeploy) {
            File newArtifact = Optional.ofNullable(this.config).map(c -> c.artifact).map(IArtifact::getFile).orElse(null);
            Optional.ofNullable(newArtifact).ifPresent(arg_0 -> ((SpringAppDeploymentImpl)deployment).withJarFile(arg_0));
        }
        return toDeploy;
    }

    @Nonnull
    public static RuntimeVersion formalizeRuntimeVersion(String runtimeVersion) {
        if (StringUtils.isEmpty((CharSequence)runtimeVersion)) {
            return DEFAULT_RUNTIME_VERSION;
        }
        String fixedRuntimeVersion = StringUtils.trim((String)runtimeVersion);
        Matcher matcher = Pattern.compile(RUNTIME_VERSION_PATTERN).matcher(fixedRuntimeVersion);
        if (matcher.matches()) {
            String v = matcher.group(3);
            return Objects.equals(v, "17") ? RuntimeVersion.JAVA_17 : (Objects.equals(v, "11") ? RuntimeVersion.JAVA_11 : RuntimeVersion.JAVA_8);
        }
        log.warn("{} is not a valid runtime version, supported values are 'Java 8', 'Java 11' and 'Java 17', using Java 8 in this deployment.", (Object)fixedRuntimeVersion);
        return DEFAULT_RUNTIME_VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object invoke(Object proxy, @Nonnull Method method, Object[] args) throws Throwable {
        args = (Object[])ObjectUtils.firstNonNull((Object[])new Object[][]{args, new Object[0]});
        if (method.getName().startsWith("set")) {
            SpringCloudDeploymentDraft springCloudDeploymentDraft = this;
            synchronized (springCloudDeploymentDraft) {
                this.config = (Config)ObjectUtils.firstNonNull((Object[])new Config[]{this.config, new Config()});
                return method.invoke((Object)this.config, args);
            }
        }
        Set<String> excludes = Collections.singleton("getArtifact");
        Object result = Objects.nonNull(this.config) ? method.invoke((Object)this.config, args) : null;
        return Objects.nonNull(result) || excludes.contains(method.getName()) ? result : this.invokeSuper(method, args);
    }

    private Object invokeSuper(@Nonnull Method method, @Nonnull Object[] args) throws Throwable {
        Class[] classes = (Class[])Arrays.stream(args).map(Object::getClass).toArray(value -> new Class[0]);
        MethodType type = MethodType.methodType(method.getReturnType(), classes);
        MethodHandle handle = MethodHandles.lookup().findSpecial(SpringCloudDeployment.class, method.getName(), type, this.getClass()).bindTo(this);
        return handle.invokeWithArguments(args);
    }

    public boolean isModified() {
        return this.toScale() || this.toUpdate() || this.toDeploy();
    }

    public boolean toScale() {
        Double newCpu = this.getCpu();
        Double newMemoryInGB = this.getMemoryInGB();
        Integer newCapacity = this.getCapacity();
        Double oldCpu = super.getCpu();
        Double oldMemoryInGB = super.getMemoryInGB();
        Integer oldCapacity = super.getCapacity();
        return !Objects.equals(newCpu, oldCpu) && Objects.nonNull(newCpu) || !Objects.equals(newMemoryInGB, oldMemoryInGB) && Objects.nonNull(newMemoryInGB) || !Objects.equals(newCapacity, oldCapacity) && Objects.nonNull(newCapacity);
    }

    public boolean toUpdate() {
        Map<String, String> newEnv = this.getEnvironmentVariables();
        String newJvmOptions = this.getJvmOptions();
        String newVersion = this.getRuntimeVersion();
        Map oldEnv = (Map)Utils.emptyToNull(super.getEnvironmentVariables());
        String oldJvmOptions = (String)Utils.emptyToNull((Object)super.getJvmOptions());
        String oldVersion = (String)Utils.emptyToNull((Object)super.getRuntimeVersion());
        return !Objects.equals(Utils.emptyToNull(newEnv), oldEnv) && Objects.nonNull(newEnv) || !Objects.equals(Utils.emptyToNull((Object)newJvmOptions), oldJvmOptions) && Objects.nonNull(newJvmOptions) || !Objects.equals(Utils.emptyToNull((Object)newVersion), oldVersion) && Objects.nonNull(newVersion);
    }

    public boolean toDeploy() {
        return Optional.ofNullable(this.config).map(c -> c.artifact).map(IArtifact::getFile).isPresent();
    }

    @Nullable
    public SpringCloudDeployment getOrigin() {
        return this.origin;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.configProxy.setEnvironmentVariables(environmentVariables);
    }

    public void setJvmOptions(String jvmOptions) {
        this.configProxy.setJvmOptions(jvmOptions);
    }

    public void setRuntimeVersion(String runtimeVersion) {
        this.configProxy.setRuntimeVersion(runtimeVersion);
    }

    public void setArtifact(IArtifact artifact) {
        this.configProxy.setArtifact(artifact);
    }

    public void setCpu(Double cpu) {
        this.configProxy.setCpu(cpu);
    }

    public void setMemoryInGB(Double memoryInGB) {
        this.configProxy.setMemoryInGB(memoryInGB);
    }

    public void setCapacity(Integer capacity) {
        this.configProxy.setCapacity(capacity);
    }

    @Override
    public Map<String, String> getEnvironmentVariables() {
        return this.configProxy.getEnvironmentVariables();
    }

    @Override
    public String getJvmOptions() {
        return this.configProxy.getJvmOptions();
    }

    @Override
    public String getRuntimeVersion() {
        return this.configProxy.getRuntimeVersion();
    }

    public IArtifact getArtifact() {
        return this.configProxy.getArtifact();
    }

    @Override
    public Double getCpu() {
        return this.configProxy.getCpu();
    }

    @Override
    public Double getMemoryInGB() {
        return this.configProxy.getMemoryInGB();
    }

    @Override
    public Integer getCapacity() {
        return this.configProxy.getCapacity();
    }

    static {
        SpringCloudDeploymentDraft.ajc$preClinit();
        log = LoggerFactory.getLogger(SpringCloudDeploymentDraft.class);
        DEFAULT_RUNTIME_VERSION = RuntimeVersion.JAVA_11;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpringCloudDeploymentDraft.java", SpringCloudDeploymentDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentDraft", "", "", "", "com.azure.resourcemanager.appplatform.models.SpringAppDeployment"), 127);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentDraft", "com.azure.resourcemanager.appplatform.models.SpringAppDeployment", "deployment", "", "com.azure.resourcemanager.appplatform.models.SpringAppDeployment"), 149);
    }

    private static interface IConfig {
        public void setEnvironmentVariables(Map<String, String> var1);

        public void setJvmOptions(String var1);

        public void setRuntimeVersion(String var1);

        public void setArtifact(IArtifact var1);

        public void setCpu(Double var1);

        public void setMemoryInGB(Double var1);

        public void setCapacity(Integer var1);

        @Nullable
        public Map<String, String> getEnvironmentVariables();

        @Nullable
        public String getJvmOptions();

        @Nullable
        public String getRuntimeVersion();

        @Nullable
        public IArtifact getArtifact();

        @Nullable
        public Double getCpu();

        @Nullable
        public Double getMemoryInGB();

        @Nullable
        public Integer getCapacity();
    }

    private static class Config
    implements IConfig {
        @Nullable
        Map<String, String> environmentVariables;
        @Nullable
        String jvmOptions;
        @Nullable
        String runtimeVersion;
        @Nullable
        IArtifact artifact;
        @Nullable
        Double cpu;
        @Nullable
        Double memoryInGB;
        @Nullable
        Integer capacity;

        @Override
        @Nullable
        public Map<String, String> getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Override
        @Nullable
        public String getJvmOptions() {
            return this.jvmOptions;
        }

        @Override
        @Nullable
        public String getRuntimeVersion() {
            return this.runtimeVersion;
        }

        @Override
        @Nullable
        public IArtifact getArtifact() {
            return this.artifact;
        }

        @Override
        @Nullable
        public Double getCpu() {
            return this.cpu;
        }

        @Override
        @Nullable
        public Double getMemoryInGB() {
            return this.memoryInGB;
        }

        @Override
        @Nullable
        public Integer getCapacity() {
            return this.capacity;
        }

        @Override
        public void setEnvironmentVariables(@Nullable Map<String, String> environmentVariables) {
            this.environmentVariables = environmentVariables;
        }

        @Override
        public void setJvmOptions(@Nullable String jvmOptions) {
            this.jvmOptions = jvmOptions;
        }

        @Override
        public void setRuntimeVersion(@Nullable String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
        }

        @Override
        public void setArtifact(@Nullable IArtifact artifact) {
            this.artifact = artifact;
        }

        @Override
        public void setCpu(@Nullable Double cpu) {
            this.cpu = cpu;
        }

        @Override
        public void setMemoryInGB(@Nullable Double memoryInGB) {
            this.memoryInGB = memoryInGB;
        }

        @Override
        public void setCapacity(@Nullable Integer capacity) {
            this.capacity = capacity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$cpu = this.getCpu();
            Double other$cpu = other.getCpu();
            if (this$cpu == null ? other$cpu != null : !((Object)this$cpu).equals(other$cpu)) {
                return false;
            }
            Double this$memoryInGB = this.getMemoryInGB();
            Double other$memoryInGB = other.getMemoryInGB();
            if (this$memoryInGB == null ? other$memoryInGB != null : !((Object)this$memoryInGB).equals(other$memoryInGB)) {
                return false;
            }
            Integer this$capacity = this.getCapacity();
            Integer other$capacity = other.getCapacity();
            if (this$capacity == null ? other$capacity != null : !((Object)this$capacity).equals(other$capacity)) {
                return false;
            }
            Map<String, String> this$environmentVariables = this.getEnvironmentVariables();
            Map<String, String> other$environmentVariables = other.getEnvironmentVariables();
            if (this$environmentVariables == null ? other$environmentVariables != null : !((Object)this$environmentVariables).equals(other$environmentVariables)) {
                return false;
            }
            String this$jvmOptions = this.getJvmOptions();
            String other$jvmOptions = other.getJvmOptions();
            if (this$jvmOptions == null ? other$jvmOptions != null : !this$jvmOptions.equals(other$jvmOptions)) {
                return false;
            }
            String this$runtimeVersion = this.getRuntimeVersion();
            String other$runtimeVersion = other.getRuntimeVersion();
            if (this$runtimeVersion == null ? other$runtimeVersion != null : !this$runtimeVersion.equals(other$runtimeVersion)) {
                return false;
            }
            IArtifact this$artifact = this.getArtifact();
            IArtifact other$artifact = other.getArtifact();
            return !(this$artifact == null ? other$artifact != null : !this$artifact.equals(other$artifact));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $cpu = this.getCpu();
            result = result * 59 + ($cpu == null ? 43 : ((Object)$cpu).hashCode());
            Double $memoryInGB = this.getMemoryInGB();
            result = result * 59 + ($memoryInGB == null ? 43 : ((Object)$memoryInGB).hashCode());
            Integer $capacity = this.getCapacity();
            result = result * 59 + ($capacity == null ? 43 : ((Object)$capacity).hashCode());
            Map<String, String> $environmentVariables = this.getEnvironmentVariables();
            result = result * 59 + ($environmentVariables == null ? 43 : ((Object)$environmentVariables).hashCode());
            String $jvmOptions = this.getJvmOptions();
            result = result * 59 + ($jvmOptions == null ? 43 : $jvmOptions.hashCode());
            String $runtimeVersion = this.getRuntimeVersion();
            result = result * 59 + ($runtimeVersion == null ? 43 : $runtimeVersion.hashCode());
            IArtifact $artifact = this.getArtifact();
            result = result * 59 + ($artifact == null ? 43 : $artifact.hashCode());
            return result;
        }

        public String toString() {
            return "SpringCloudDeploymentDraft.Config(environmentVariables=" + this.getEnvironmentVariables() + ", jvmOptions=" + this.getJvmOptions() + ", runtimeVersion=" + this.getRuntimeVersion() + ", artifact=" + this.getArtifact() + ", cpu=" + this.getCpu() + ", memoryInGB=" + this.getMemoryInGB() + ", capacity=" + this.getCapacity() + ")";
        }
    }
}

