/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.core.util.ExpandableStringEnum;
import com.azure.resourcemanager.appplatform.fluent.AppPlatformManagementClient;
import com.azure.resourcemanager.appplatform.fluent.models.DeploymentResourceInner;
import com.azure.resourcemanager.appplatform.fluent.models.RemoteDebuggingInner;
import com.azure.resourcemanager.appplatform.models.DeploymentInstance;
import com.azure.resourcemanager.appplatform.models.DeploymentSettings;
import com.azure.resourcemanager.appplatform.models.RemoteDebuggingPayload;
import com.azure.resourcemanager.appplatform.models.SpringAppDeployment;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasManager;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.utils.Debouncer;
import com.microsoft.azure.toolkit.lib.common.utils.TailingDebouncer;
import com.microsoft.azure.toolkit.lib.servicelinker.ServiceLinkerConsumer;
import com.microsoft.azure.toolkit.lib.servicelinker.ServiceLinkerModule;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudAppInstance;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudAppInstanceModule;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudCluster;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentModule;
import com.microsoft.azure.toolkit.lib.springcloud.Utils;
import java.time.Duration;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import reactor.core.Disposable;
import reactor.core.scheduler.Schedulers;

public class SpringCloudDeployment
extends AbstractAzResource<SpringCloudDeployment, SpringCloudApp, SpringAppDeployment>
implements ServiceLinkerConsumer {
    @Nonnull
    private final SpringCloudAppInstanceModule instanceModule;
    private final ServiceLinkerModule linkerModule;
    private boolean remoteDebuggingEnabled;
    private Disposable disposable;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    protected SpringCloudDeployment(@Nonnull String name, @Nonnull SpringCloudDeploymentModule module) {
        super(name, (AbstractAzResourceModule)module);
        this.instanceModule = new SpringCloudAppInstanceModule(this);
        this.linkerModule = new ServiceLinkerModule(this.getId(), (ServiceLinkerConsumer)this);
    }

    protected SpringCloudDeployment(@Nonnull SpringCloudDeployment origin) {
        super((AbstractAzResource)origin);
        this.instanceModule = origin.instanceModule;
        this.remoteDebuggingEnabled = origin.remoteDebuggingEnabled;
        this.linkerModule = origin.linkerModule;
    }

    protected SpringCloudDeployment(@Nonnull SpringAppDeployment remote, @Nonnull SpringCloudDeploymentModule module) {
        super(remote.name(), (AbstractAzResourceModule)module);
        this.instanceModule = new SpringCloudAppInstanceModule(this);
        this.linkerModule = new ServiceLinkerModule(this.getId(), (ServiceLinkerConsumer)this);
    }

    @AzureOperation(name="azure/springcloud.start_deployment.deployment", params={"this.getName()"})
    public void start() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> ((SpringAppDeployment)Objects.requireNonNull(this.getRemote())).start(), "Starting");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/springcloud.stop_deployment.deployment", params={"this.getName()"})
    public void stop() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> ((SpringAppDeployment)Objects.requireNonNull(this.getRemote())).stop(), "Stopping");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/springcloud.restart_deployment.deployment", params={"this.getName()"})
    public void restart() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> ((SpringAppDeployment)Objects.requireNonNull(this.getRemote())).restart(), "Restarting");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    protected String loadStatus(@Nonnull SpringAppDeployment remote) {
        return Optional.of(remote).map(SpringAppDeployment::status).map(ExpandableStringEnum::toString).orElse("Unknown");
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Arrays.asList(new AbstractAzResourceModule[]{this.instanceModule, this.linkerModule});
    }

    protected void updateAdditionalProperties(SpringAppDeployment newRemote, SpringAppDeployment oldRemote) {
        SpringCloudApp app = (SpringCloudApp)this.getParent();
        SpringCloudCluster cluster = (SpringCloudCluster)app.getParent();
        this.remoteDebuggingEnabled = Objects.nonNull(newRemote) && this.isRemoteDebuggingSupported() ? Optional.ofNullable(cluster.getRemote()).map(HasManager::manager).map(Manager::serviceClient).map(AppPlatformManagementClient::getDeployments).map(c -> c.getRemoteDebuggingConfig(this.getResourceGroupName(), cluster.getName(), app.getName(), this.getName())).map(RemoteDebuggingInner::enabled).orElse(false) : false;
    }

    @AzureOperation(name="internal/springcloud.wait_until_deployment_ready.deployment|app", params={"this.getName()", "this.getParent().getName()"})
    public boolean waitUntilReady(int timeoutInSeconds) {
        int n = timeoutInSeconds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            SpringCloudDeployment deployment = Utils.pollUntil(() -> {
                this.invalidateCache();
                return this;
            }, Utils::isDeploymentDone, timeoutInSeconds);
            boolean bl = Utils.isDeploymentDone(deployment);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nullable
    public Double getCpu() {
        return Optional.ofNullable(this.getRemote()).map(SpringAppDeployment::cpu).orElse(null);
    }

    @Nullable
    public Double getMemoryInGB() {
        return Optional.ofNullable(this.getRemote()).map(SpringAppDeployment::memoryInGB).orElse(null);
    }

    @Nullable
    public String getRuntimeVersion() {
        return Optional.ofNullable(this.getRemote()).map(SpringAppDeployment::runtimeVersion).map(ExpandableStringEnum::toString).orElse(null);
    }

    @Nullable
    public String getJvmOptions() {
        return Optional.ofNullable(this.getRemote()).map(SpringAppDeployment::jvmOptions).orElse(null);
    }

    @Nullable
    public Map<String, String> getEnvironmentVariables() {
        return Optional.ofNullable(this.getRemote()).map(SpringAppDeployment::settings).map(DeploymentSettings::environmentVariables).map(v -> {
            HashMap variables = new HashMap(v);
            if (((SpringCloudCluster)((SpringCloudApp)this.getParent()).getParent()).isEnterpriseTier() && StringUtils.isBlank((CharSequence)((CharSequence)variables.get("JAVA_OPTS")))) {
                variables.remove("JAVA_OPTS");
            }
            return variables;
        }).orElse(null);
    }

    public List<SpringCloudAppInstance> getInstances() {
        return this.instanceModule.list();
    }

    @Nullable
    public Integer getCapacity() {
        if (((SpringCloudCluster)((SpringCloudApp)this.getParent()).getParent()).isConsumptionTier()) {
            return this.remoteOptional().map(r -> ((DeploymentResourceInner)r.innerModel()).properties().deploymentSettings().scale().maxReplicas()).orElse(null);
        }
        return this.remoteOptional().map(SpringAppDeployment::instances).map(List::size).orElse(null);
    }

    @Nonnull
    public Boolean isActive() {
        return Optional.ofNullable(this.getRemote()).map(SpringAppDeployment::isActive).orElse(false);
    }

    public void setStatus(@Nonnull String status) {
        super.setStatus(status);
        if (this.isActive().booleanValue()) {
            ((SpringCloudApp)this.getParent()).setStatus(status);
        }
    }

    @AzureOperation(name="azure/springcloud.enable_remote_debugging.deployment", params={"this.getName()"})
    public void enableRemoteDebugging(int port) {
        int n = port;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.validateRemoteDebuggingSupport();
            SpringCloudApp app = (SpringCloudApp)this.getParent();
            SpringCloudCluster cluster = (SpringCloudCluster)app.getParent();
            RemoteDebuggingPayload payload = new RemoteDebuggingPayload().withPort(Integer.valueOf(port));
            Optional.ofNullable(cluster.getRemote()).map(HasManager::manager).map(Manager::serviceClient).map(AppPlatformManagementClient::getDeployments).ifPresent(c -> this.doModify(() -> {
                RemoteDebuggingInner cfr_ignored_0 = (RemoteDebuggingInner)c.enableRemoteDebuggingAsync(this.getResourceGroupName(), cluster.getName(), app.getName(), this.getName(), payload).block();
            }, "Updating"));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/springcloud.disable_remote_debugging.deployment", params={"this.getName()"})
    public void disableRemoteDebugging() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            SpringCloudApp app = (SpringCloudApp)this.getParent();
            SpringCloudCluster cluster = (SpringCloudCluster)app.getParent();
            Optional.ofNullable(cluster.getRemote()).map(HasManager::manager).map(Manager::serviceClient).map(AppPlatformManagementClient::getDeployments).ifPresent(c -> this.doModify(() -> c.disableRemoteDebugging(this.getResourceGroupName(), cluster.getName(), app.getName(), this.getName()), "Updating"));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public boolean isRemoteDebuggingEnabled() {
        return this.remoteDebuggingEnabled;
    }

    public int getRemoteDebuggingPort() {
        this.validateRemoteDebuggingSupport();
        SpringCloudApp app = (SpringCloudApp)this.getParent();
        SpringCloudCluster cluster = (SpringCloudCluster)app.getParent();
        return Optional.ofNullable(cluster.getRemote()).map(HasManager::manager).map(Manager::serviceClient).map(AppPlatformManagementClient::getDeployments).map(c -> c.getRemoteDebuggingConfig(this.getResourceGroupName(), cluster.getName(), app.getName(), this.getName())).map(RemoteDebuggingInner::port).orElseThrow(() -> new AzureToolkitRuntimeException("Failed to get remote debugging port."));
    }

    private void validateRemoteDebuggingSupport() {
        if (!this.isRemoteDebuggingSupported()) {
            throw new AzureToolkitRuntimeException("Remote debugging is not supported for Azure Spring apps of consumption plan for now.");
        }
    }

    private boolean isRemoteDebuggingSupported() {
        return !((SpringCloudCluster)((SpringCloudApp)this.getParent()).getParent()).isConsumptionTier();
    }

    @Nullable
    public SpringCloudAppInstance getLatestInstance() {
        return this.getInstances().stream().filter(springCloudAppInstance -> Objects.nonNull(springCloudAppInstance.getRemote())).max(Comparator.comparing(instance -> ((DeploymentInstance)Objects.requireNonNull(instance.getRemote())).startTime())).orElse(null);
    }

    public void startStreamingLog(boolean follow) {
        IAzureMessager messager = AzureMessager.getMessager();
        Optional.ofNullable(this.getLatestInstance()).ifPresent(i -> {
            messager.info(AzureString.format((String)"Opening streaming log of instance({0})...", (Object[])new Object[]{i.getName()}));
            messager.debug("###############STREAMING LOG BEGIN##################");
            CountDownLatch latch = new CountDownLatch(1);
            TailingDebouncer fireEvents = new TailingDebouncer(() -> {
                this.stopStreamingLog();
                latch.countDown();
            }, Long.valueOf(Duration.ofSeconds(15L).toMillis()).intValue());
            SpringCloudCluster service = (SpringCloudCluster)((SpringCloudApp)this.getParent()).getParent();
            this.disposable = this.getLatestInstance().streamingLogs(follow, service.isConsumptionTier() ? 300 : 500).doFinally(type -> messager.debug("###############STREAMING LOG END##################")).subscribeOn(Schedulers.boundedElastic()).subscribe(arg_0 -> SpringCloudDeployment.lambda$null$17(messager, (Debouncer)fireEvents, arg_0));
            fireEvents.debounce();
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                this.stopStreamingLog();
            }
            finally {
                latch.countDown();
            }
        });
    }

    private void stopStreamingLog() {
        if (!this.disposable.isDisposed()) {
            this.disposable.dispose();
        }
    }

    public ServiceLinkerModule getServiceLinkerModule() {
        return this.linkerModule;
    }

    private static /* synthetic */ void lambda$null$17(IAzureMessager messager, Debouncer fireEvents, String s) {
        messager.debug(s);
        fireEvents.debounce();
    }

    static {
        SpringCloudDeployment.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpringCloudDeployment.java", SpringCloudDeployment.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment", "", "", "", "void"), 77);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment", "", "", "", "void"), 82);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "restart", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment", "", "", "", "void"), 87);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilReady", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment", "int", "timeoutInSeconds", "", "boolean"), 123);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "enableRemoteDebugging", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment", "int", "port", "", "void"), 203);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "disableRemoteDebugging", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment", "", "", "", "void"), 216);
    }
}

