/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.resourcemanager.appplatform.AppPlatformManager;
import com.azure.resourcemanager.appplatform.models.SpringService;
import com.azure.resourcemanager.appplatform.models.SpringServices;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudCluster;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudClusterDraft;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudServiceSubscription;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class SpringCloudClusterModule
extends AbstractAzResourceModule<SpringCloudCluster, SpringCloudServiceSubscription, SpringService> {
    public static final String NAME = "Spring";

    public SpringCloudClusterModule(@Nonnull SpringCloudServiceSubscription parent) {
        super(NAME, (AzResource)parent);
    }

    @Nullable
    public SpringServices getClient() {
        return Optional.ofNullable(((SpringCloudServiceSubscription)this.parent).getRemote()).map(AppPlatformManager::springServices).orElse(null);
    }

    @Nullable
    public SpringCloudCluster get(@Nonnull String name, @Nullable String resourceGroup) {
        if (StringUtils.isBlank((CharSequence)(resourceGroup = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{resourceGroup, ((SpringCloudServiceSubscription)this.getParent()).getResourceGroupName()}))) || StringUtils.equalsIgnoreCase((CharSequence)resourceGroup, (CharSequence)"${rg}")) {
            return this.list().stream().filter(c -> StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)c.getName())).findAny().orElse(null);
        }
        return (SpringCloudCluster)super.get(name, resourceGroup);
    }

    @Nonnull
    protected SpringCloudCluster newResource(@Nonnull SpringService r) {
        return new SpringCloudCluster(r, this);
    }

    @Nonnull
    protected SpringCloudCluster newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new SpringCloudCluster(name, Objects.requireNonNull(resourceGroupName), this);
    }

    @Nonnull
    protected AzResource.Draft<SpringCloudCluster, SpringService> newDraftForCreate(@Nonnull String name, @Nullable String rgName) {
        assert (rgName != null) : "'Resource group' is required.";
        return new SpringCloudClusterDraft(name, rgName, this);
    }

    @Nonnull
    protected AzResource.Draft<SpringCloudCluster, SpringService> newDraftForUpdate(@Nonnull SpringCloudCluster springCloudCluster) {
        return new SpringCloudClusterDraft(springCloudCluster);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Spring Apps";
    }
}

