/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.core.management.Region;
import com.azure.resourcemanager.appplatform.AppPlatformManager;
import com.azure.resourcemanager.appplatform.fluent.AppPlatformManagementClient;
import com.azure.resourcemanager.appplatform.models.BuilderProvisioningState;
import com.azure.resourcemanager.appplatform.models.SpringService;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.action.AzureActionManager;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupDraft;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudCluster;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudClusterModule;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudServiceSubscription;
import com.microsoft.azure.toolkit.lib.springcloud.model.Sku;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.NotImplementedException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringCloudClusterDraft
extends SpringCloudCluster
implements AzResource.Draft<SpringCloudCluster, SpringService> {
    private static final Logger log;
    @Nullable
    private final SpringCloudCluster origin;
    @Nullable
    private Config config;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    SpringCloudClusterDraft(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull SpringCloudClusterModule module) {
        super(name, resourceGroupName, module);
        this.origin = null;
    }

    SpringCloudClusterDraft(@Nonnull SpringCloudCluster origin) {
        super(origin);
        this.origin = origin;
    }

    public SpringCloudClusterDraft withConfig(Config config) {
        this.setConfig(config);
        return this;
    }

    public void reset() {
        this.config = null;
    }

    @Nonnull
    @AzureOperation(name="azure/springcloud.create_service.service", params={"this.getName()"})
    public SpringService createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            IAzureMessager messager = AzureMessager.getMessager();
            ResourceGroup rg = Objects.requireNonNull(this.getResourceGroup());
            if (rg.isDraftForCreating()) {
                ((ResourceGroupDraft)rg).createIfNotExist();
            }
            String rgName = this.getResourceGroupName();
            Region region = Objects.requireNonNull(this.getRegion(), "'Region' is required.");
            String serviceName = this.getName();
            AppPlatformManager manager = (AppPlatformManager)Objects.requireNonNull(((SpringCloudServiceSubscription)this.getParent()).getRemote());
            messager.info(AzureString.format((String)"Start creating Spring apps ({0})...", (Object[])new Object[]{serviceName}));
            ((SpringService.DefinitionStages.WithCreate)((SpringService.DefinitionStages.WithGroup)((SpringService.DefinitionStages.Blank)manager.springServices().define(this.getName())).withRegion(region)).withExistingResourceGroup(rgName)).withSku((com.azure.resourcemanager.appplatform.models.Sku)Optional.ofNullable(this.getSku()).map(Sku::toSku).orElse(null)).create();
            if (this.isEnterpriseTier()) {
                BuilderProvisioningState provisioningState = ((AppPlatformManagementClient)manager.serviceClient()).getBuildServiceBuilders().get(rgName, serviceName, "default", "default").properties().provisioningState();
                while (provisioningState != BuilderProvisioningState.SUCCEEDED) {
                    provisioningState = ((AppPlatformManagementClient)manager.serviceClient()).getBuildServiceBuilders().get(rgName, serviceName, "default", "default").properties().provisioningState();
                    ResourceManagerUtils.sleep((Duration)Duration.ofSeconds(5L));
                    log.debug("Waiting for builder ready...");
                }
            }
            Action create = AzureActionManager.getInstance().getAction(AzResource.CREATE_RESOURCE).bind((Object)this).withLabel("Create app");
            messager.success(AzureString.format((String)"Spring apps ({0}) is successfully created.", (Object[])new Object[]{serviceName}), new Object[]{create});
            SpringService springService = (SpringService)manager.springServices().getByResourceGroup(rgName, this.getName());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return springService;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="azure/springcloud.update_app.app", params={"this.getName()"})
    public SpringService updateResourceInAzure(@Nonnull SpringService service) {
        SpringService springService = service;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)springService);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            throw new NotImplementedException("Update Spring Cloud Cluster is not supported yet");
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    private synchronized Config ensureConfig() {
        this.config = Optional.ofNullable(this.config).orElseGet(Config::new);
        return this.config;
    }

    public boolean isModified() {
        return false;
    }

    public void setName(@Nonnull String name) {
        this.ensureConfig().setName(name);
    }

    @Nonnull
    public String getName() {
        return Optional.ofNullable(this.config).map(Config::getName).orElseGet(() -> super.getName());
    }

    @Override
    @Nullable
    public Region getRegion() {
        return Optional.ofNullable(this.config).map(Config::getRegion).orElseGet(() -> super.getRegion());
    }

    @Override
    @Nullable
    public Sku getSku() {
        return Optional.ofNullable(this.config).map(Config::getSku).orElseGet(() -> super.getSku());
    }

    @Nullable
    public ResourceGroup getResourceGroup() {
        return Optional.ofNullable(this.config).map(Config::getResourceGroup).orElseGet(() -> super.getResourceGroup());
    }

    @Override
    @Nullable
    public String getManagedEnvironmentId() {
        return Optional.ofNullable(this.config).map(Config::getManagedEnvironmentId).orElseGet(() -> super.getManagedEnvironmentId());
    }

    @Nullable
    public SpringCloudCluster getOrigin() {
        return this.origin;
    }

    public void setConfig(@Nullable Config config) {
        this.config = config;
    }

    static {
        SpringCloudClusterDraft.ajc$preClinit();
        log = LoggerFactory.getLogger(SpringCloudClusterDraft.class);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpringCloudClusterDraft.java", SpringCloudClusterDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudClusterDraft", "", "", "", "com.azure.resourcemanager.appplatform.models.SpringService"), 72);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudClusterDraft", "com.azure.resourcemanager.appplatform.models.SpringService", "service", "", "com.azure.resourcemanager.appplatform.models.SpringService"), 109);
    }

    public static class Config {
        private String name;
        @Nullable
        private Region region;
        @Nullable
        private Sku sku;
        @Nullable
        private String managedEnvironmentId;
        @Nullable
        private ResourceGroup resourceGroup;

        public String getName() {
            return this.name;
        }

        @Nullable
        public Region getRegion() {
            return this.region;
        }

        @Nullable
        public Sku getSku() {
            return this.sku;
        }

        @Nullable
        public String getManagedEnvironmentId() {
            return this.managedEnvironmentId;
        }

        @Nullable
        public ResourceGroup getResourceGroup() {
            return this.resourceGroup;
        }

        public Config setName(String name) {
            this.name = name;
            return this;
        }

        public Config setRegion(@Nullable Region region) {
            this.region = region;
            return this;
        }

        public Config setSku(@Nullable Sku sku) {
            this.sku = sku;
            return this;
        }

        public Config setManagedEnvironmentId(@Nullable String managedEnvironmentId) {
            this.managedEnvironmentId = managedEnvironmentId;
            return this;
        }

        public Config setResourceGroup(@Nullable ResourceGroup resourceGroup) {
            this.resourceGroup = resourceGroup;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Region this$region = this.getRegion();
            Region other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            Sku this$sku = this.getSku();
            Sku other$sku = other.getSku();
            if (this$sku == null ? other$sku != null : !((Object)this$sku).equals(other$sku)) {
                return false;
            }
            String this$managedEnvironmentId = this.getManagedEnvironmentId();
            String other$managedEnvironmentId = other.getManagedEnvironmentId();
            if (this$managedEnvironmentId == null ? other$managedEnvironmentId != null : !this$managedEnvironmentId.equals(other$managedEnvironmentId)) {
                return false;
            }
            ResourceGroup this$resourceGroup = this.getResourceGroup();
            ResourceGroup other$resourceGroup = other.getResourceGroup();
            return !(this$resourceGroup == null ? other$resourceGroup != null : !this$resourceGroup.equals(other$resourceGroup));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Region $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            Sku $sku = this.getSku();
            result = result * 59 + ($sku == null ? 43 : ((Object)$sku).hashCode());
            String $managedEnvironmentId = this.getManagedEnvironmentId();
            result = result * 59 + ($managedEnvironmentId == null ? 43 : $managedEnvironmentId.hashCode());
            ResourceGroup $resourceGroup = this.getResourceGroup();
            result = result * 59 + ($resourceGroup == null ? 43 : $resourceGroup.hashCode());
            return result;
        }

        public String toString() {
            return "SpringCloudClusterDraft.Config(name=" + this.getName() + ", region=" + this.getRegion() + ", sku=" + this.getSku() + ", managedEnvironmentId=" + this.getManagedEnvironmentId() + ", resourceGroup=" + this.getResourceGroup() + ")";
        }
    }
}

