/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.core.util.paging.ContinuablePage;
import com.azure.resourcemanager.appplatform.models.DeploymentInstance;
import com.azure.resourcemanager.appplatform.models.SpringAppDeployment;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.page.ItemPage;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudAppInstance;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SpringCloudAppInstanceModule
extends AbstractAzResourceModule<SpringCloudAppInstance, SpringCloudDeployment, DeploymentInstance> {
    public static final String NAME = "instances";

    public SpringCloudAppInstanceModule(@Nonnull SpringCloudDeployment parent) {
        super(NAME, (AzResource)parent);
    }

    @Nullable
    protected List<DeploymentInstance> getClient() {
        return Optional.ofNullable(((SpringCloudDeployment)this.parent).getRemote()).map(SpringAppDeployment::instances).orElse(null);
    }

    @Nullable
    protected DeploymentInstance loadResourceFromAzure(@Nonnull String name, @Nullable String resourceGroup) {
        List deploymentInstanceList = Optional.ofNullable(this.getClient()).orElse(Collections.emptyList());
        return deploymentInstanceList.stream().filter(instance -> name.equals(instance.name())).findAny().orElse(null);
    }

    @Nonnull
    protected Iterator<? extends ContinuablePage<String, DeploymentInstance>> loadResourcePagesFromAzure() {
        List deploymentInstanceList = Optional.ofNullable(this.getClient()).orElse(Collections.emptyList());
        return Collections.singletonList(new ItemPage(deploymentInstanceList)).iterator();
    }

    @Nonnull
    protected SpringCloudAppInstance newResource(@Nonnull DeploymentInstance deploymentInstance) {
        return new SpringCloudAppInstance(deploymentInstance, this);
    }

    @Nonnull
    protected SpringCloudAppInstance newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new SpringCloudAppInstance(name, this);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Spring App instance";
    }
}

