/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.legacy.function.template;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.microsoft.azure.toolkit.lib.legacy.function.configurations.FunctionExtensionVersion;
import com.microsoft.azure.toolkit.lib.legacy.function.template.TemplateMetadata;
import com.microsoft.azure.toolkit.lib.legacy.function.template.TemplateTriggerTypeDeserializer;
import com.microsoft.azure.toolkit.lib.legacy.function.utils.FunctionUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class FunctionTemplate {
    private TemplateMetadata metadata;
    private Map<String, String> files;
    private List<String> bundle;
    @JsonDeserialize(using=TemplateTriggerTypeDeserializer.class)
    private String function;

    @JsonGetter
    public TemplateMetadata getMetadata() {
        return this.metadata;
    }

    @JsonSetter
    public void setMetadata(TemplateMetadata metadata) {
        this.metadata = metadata;
    }

    @JsonGetter
    public Map<String, String> getFiles() {
        return this.files;
    }

    @JsonSetter
    public void setFiles(Map<String, String> files) {
        this.files = files;
    }

    @JsonGetter
    public String getFunction() {
        return this.function;
    }

    @JsonSetter
    public void setFunction(String function) {
        this.function = function;
    }

    @JsonSetter
    public List<String> getBundle() {
        return this.bundle;
    }

    @JsonSetter
    public void setBundle(List<String> bundle) {
        this.bundle = bundle;
    }

    public Set<FunctionExtensionVersion> getSupportedExtensionVersions() {
        return CollectionUtils.isEmpty(this.bundle) ? null : this.bundle.stream().map(FunctionUtils::parseFunctionExtensionVersion).collect(Collectors.toSet());
    }

    public String getTriggerType() {
        return this.function;
    }
}

