/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.function;

import com.azure.resourcemanager.appservice.models.PlatformArchitecture;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase;
import com.microsoft.azure.toolkit.lib.appservice.deploy.FTPFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.deploy.IFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.deploy.MSFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.deploy.RunFromBlobFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.deploy.RunFromZipFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.deploy.ZIPFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.file.AzureFunctionsAdminClient;
import com.microsoft.azure.toolkit.lib.appservice.file.IFileClient;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionDeployType;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public abstract class FunctionAppBase<T extends FunctionAppBase<T, P, F>, P extends AbstractAzResource<P, ?, ?>, F extends WebAppBase>
extends AppServiceAppBase<T, P, F> {
    private static final String FUNCTION_DEPLOY_TYPE = "functionDeployType";
    public static final String JAVA_OPTS = "JAVA_OPTS";
    public static final String HTTP_PLATFORM_DEBUG_PORT = "HTTP_PLATFORM_DEBUG_PORT";
    public static final String PREFER_IPV_4_STACK_TRUE = "-Djava.net.preferIPv4Stack=true";
    public static final String XDEBUG = "-Xdebug";
    public static final String XRUNJDWP = "-Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=127.0.0.1:%s";
    public static final String DEFAULT_REMOTE_DEBUG_PORT = "8898";
    public static final String DEFAULT_REMOTE_DEBUG_JAVA_OPTS = "-Djava.net.preferIPv4Stack=true -Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=127.0.0.1:%s";
    private Boolean isEnableRemoteDebugging = null;
    private AzureFunctionsAdminClient fileClient;

    protected FunctionAppBase(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull AbstractAzResourceModule<T, P, WebSiteBase> module) {
        super(name, resourceGroupName, module);
    }

    protected FunctionAppBase(@Nonnull String name, @Nonnull AbstractAzResourceModule<T, P, WebSiteBase> module) {
        super(name, module);
    }

    protected FunctionAppBase(@Nonnull T origin) {
        super(origin);
    }

    public void deploy(File targetFile) {
        this.deploy(targetFile, this.getDefaultDeployType());
    }

    public void deploy(File targetFile, FunctionDeployType functionDeployType) {
        OperationContext.action().setTelemetryProperty(FUNCTION_DEPLOY_TYPE, functionDeployType.name());
        this.getDeployHandlerByType(functionDeployType).deploy(targetFile, (WebAppBase)this.getFullRemote());
    }

    protected AzureFunctionsAdminClient getAdminClient() {
        if (this.fileClient == null) {
            this.fileClient = Optional.ofNullable(this.getFullRemote()).map(r -> AzureFunctionsAdminClient.getClient(r, this)).orElse(null);
        }
        return this.fileClient;
    }

    @Override
    @Nullable
    protected IFileClient getFileClient() {
        return this.getAdminClient();
    }

    protected FunctionDeployType getDefaultDeployType() {
        PricingTier pricingTier = Optional.ofNullable(this.getAppServicePlan()).map(AppServicePlan::getPricingTier).orElse(PricingTier.PREMIUM_P1V2);
        OperatingSystem os = Optional.ofNullable(this.getRuntime()).map(Runtime::getOperatingSystem).orElse(OperatingSystem.LINUX);
        if (os == OperatingSystem.WINDOWS) {
            return FunctionDeployType.RUN_FROM_ZIP;
        }
        return StringUtils.equalsAnyIgnoreCase((CharSequence)pricingTier.getTier(), (CharSequence[])new CharSequence[]{"Dynamic", "ElasticPremium"}) ? FunctionDeployType.RUN_FROM_BLOB : FunctionDeployType.RUN_FROM_ZIP;
    }

    protected IFunctionDeployHandler getDeployHandlerByType(FunctionDeployType deployType) {
        switch (deployType) {
            case FTP: {
                return new FTPFunctionDeployHandler();
            }
            case ZIP: {
                return new ZIPFunctionDeployHandler();
            }
            case MSDEPLOY: {
                return new MSFunctionDeployHandler();
            }
            case RUN_FROM_ZIP: {
                return new RunFromZipFunctionDeployHandler();
            }
            case RUN_FROM_BLOB: {
                return new RunFromBlobFunctionDeployHandler();
            }
        }
        throw new AzureToolkitRuntimeException("Unsupported deployment type");
    }

    public abstract String getMasterKey();

    public boolean isRemoteDebugEnabled() {
        if (this.isEnableRemoteDebugging == null) {
            this.isEnableRemoteDebugging = this.getIsRemoteDebuggingEnabled();
        }
        return this.isEnableRemoteDebugging;
    }

    public abstract void enableRemoteDebug();

    public abstract void disableRemoteDebug();

    public void ping() {
        this.getAdminClient().ping();
    }

    protected String getRemoteDebugPort() {
        return DEFAULT_REMOTE_DEBUG_PORT;
    }

    public String getJavaOptsWithRemoteDebugDisabled(Map<String, String> appSettings) {
        String javaOpts = appSettings.get(JAVA_OPTS);
        if (StringUtils.isEmpty((CharSequence)javaOpts)) {
            return String.format("", new Object[0]);
        }
        return Arrays.stream(javaOpts.split(" ")).filter(opts -> !StringUtils.containsAnyIgnoreCase((CharSequence)opts, (CharSequence[])new CharSequence[]{PREFER_IPV_4_STACK_TRUE, XDEBUG, "-Xrunjdwp"})).collect(Collectors.joining(" "));
    }

    public String getJavaOptsWithRemoteDebugEnabled(Map<String, String> appSettings, String debugPort) {
        String javaOpts = appSettings.get(JAVA_OPTS);
        if (StringUtils.isEmpty((CharSequence)javaOpts)) {
            return String.format(DEFAULT_REMOTE_DEBUG_JAVA_OPTS, debugPort);
        }
        ArrayList<String> jvmOptions = new ArrayList<String>(Arrays.asList(javaOpts.split(" ")));
        String jdwp = String.format(XRUNJDWP, debugPort);
        for (String configuration : Arrays.asList(PREFER_IPV_4_STACK_TRUE, XDEBUG, jdwp)) {
            if (jvmOptions.contains(configuration)) continue;
            jvmOptions.add(configuration);
        }
        return String.join((CharSequence)" ", jvmOptions);
    }

    protected void updateAdditionalProperties(@Nullable WebSiteBase newRemote, @Nullable WebSiteBase oldRemote) {
        super.updateAdditionalProperties((Object)newRemote, (Object)oldRemote);
        this.isEnableRemoteDebugging = Objects.nonNull(newRemote) ? Boolean.valueOf(this.getIsRemoteDebuggingEnabled()) : null;
    }

    private boolean getIsRemoteDebuggingEnabled() {
        WebAppBase remote = (WebAppBase)Objects.requireNonNull(this.getFullRemote());
        Map<String, String> appSettings = Objects.requireNonNull(this.getAppSettings());
        boolean configEnabled = remote.webSocketsEnabled() && remote.platformArchitecture() == PlatformArchitecture.X64;
        boolean appSettingsEnabled = appSettings.containsKey(HTTP_PLATFORM_DEBUG_PORT) && StringUtils.equalsIgnoreCase((CharSequence)appSettings.get(JAVA_OPTS), (CharSequence)this.getJavaOptsWithRemoteDebugEnabled(appSettings, appSettings.get(HTTP_PLATFORM_DEBUG_PORT)));
        return configEnabled && appSettingsEnabled;
    }
}

