/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.file;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.models.FunctionApp;
import com.azure.resourcemanager.appservice.models.FunctionDeploymentSlot;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.resources.fluentcore.policy.AuthenticationPolicy;
import com.azure.resourcemanager.resources.fluentcore.policy.AuxiliaryAuthenticationPolicy;
import com.azure.resourcemanager.resources.fluentcore.policy.ProviderRegistrationPolicy;
import com.microsoft.azure.toolkit.lib.appservice.file.IFileClient;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.model.AppServiceFile;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.utils.Utils;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AzureFunctionsAdminClient
implements IFileClient {
    private static final String LINUX_ROOT = "home";
    private final String host;
    private final FunctionsService functionsService;
    private final FunctionAppBase<?, ?, ?> app;

    private AzureFunctionsAdminClient(FunctionsService functionsService, FunctionAppBase<?, ?, ?> app) {
        this.app = app;
        this.functionsService = functionsService;
        this.host = String.format("https://%s", app.getHostName());
    }

    public static AzureFunctionsAdminClient getClient(@Nonnull WebAppBase functionApp, @Nonnull FunctionAppBase<?, ?, ?> appService) {
        if (!(functionApp instanceof FunctionApp) && !(functionApp instanceof FunctionDeploymentSlot)) {
            throw new AzureToolkitRuntimeException("Functions resource manager only applies to Azure Functions");
        }
        List<HttpPipelinePolicy> policies = Utils.getPolicyFromPipeline(((AppServiceManager)functionApp.manager()).httpPipeline(), policy -> !(policy instanceof AuthenticationPolicy) && !(policy instanceof ProviderRegistrationPolicy) && !(policy instanceof AuxiliaryAuthenticationPolicy));
        policies.add((HttpPipelinePolicy)new AddHeadersPolicy(new HttpHeaders(Collections.singletonMap("x-functions-key", appService.getMasterKey()))));
        HttpPipeline httpPipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(((AppServiceManager)functionApp.manager()).httpPipeline().getHttpClient()).build();
        FunctionsService functionsService = (FunctionsService)RestProxy.create(FunctionsService.class, (HttpPipeline)httpPipeline, (SerializerAdapter)SerializerFactory.createDefaultManagementSerializerAdapter());
        return new AzureFunctionsAdminClient(functionsService, appService);
    }

    @Override
    public Flux<ByteBuffer> getFileContent(String path) {
        return this.functionsService.getFileContent(this.host, this.getFixedPath(path)).flatMapMany(StreamResponse::getValue);
    }

    @Override
    public List<? extends AppServiceFile> getFilesInDirectory(String dir) {
        return ((List)((Response)this.functionsService.getFilesInDirectory(this.host, this.getFixedPath(dir)).block()).getValue()).stream().filter(file -> !"text/xml".equals(file.getMime()) || !file.getName().contains("LogFiles-kudu-trace_pending.xml")).map(file -> file.withApp(this.app).withPath(Paths.get(dir, file.getName()).toString())).collect(Collectors.toList());
    }

    @Override
    public AppServiceFile getFileByPath(String path) {
        File file = new File(path);
        List<? extends AppServiceFile> result = this.getFilesInDirectory(this.getFixedPath(file.getParent()));
        return result.stream().filter(appServiceFile -> StringUtils.equals((CharSequence)file.getName(), (CharSequence)appServiceFile.getName())).findFirst().orElse(null);
    }

    @Override
    public void uploadFileToPath(String content, String path) {
        this.functionsService.saveFile(this.host, this.getFixedPath(path), content).block();
    }

    @Override
    public void createDirectory(String path) {
        this.functionsService.createDirectory(this.host, this.getFixedPath(path)).block();
    }

    @Override
    public void deleteFile(String path) {
        this.functionsService.deleteFile(this.host, this.getFixedPath(path)).block();
    }

    private String getFixedPath(String originPath) {
        return this.app.getRuntime().getOperatingSystem() == OperatingSystem.WINDOWS || StringUtils.startsWithIgnoreCase((CharSequence)originPath, (CharSequence)LINUX_ROOT) ? originPath : Paths.get(LINUX_ROOT, originPath).toString();
    }

    public void ping() {
        this.functionsService.ping(this.host).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="FunctionHost")
    private static interface FunctionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @Post(value="admin/host/ping")
        public Mono<Void> ping(@HostParam(value="$host") String var1);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @Get(value="admin/vfs/{path}")
        public Mono<StreamResponse> getFileContent(@HostParam(value="$host") String var1, @PathParam(value="path") String var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @Get(value="admin/vfs/{path}/")
        public Mono<Response<List<AppServiceFile>>> getFilesInDirectory(@HostParam(value="$host") String var1, @PathParam(value="path") String var2);

        @Headers(value={"Content-Type: application/octet-stream; charset=utf-8", "If-Match: *"})
        @Put(value="admin/vfs/{path}")
        public Mono<Void> saveFile(@HostParam(value="$host") String var1, @PathParam(value="path") String var2, @BodyParam(value="application/octet-stream") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @Put(value="admin/vfs/{path}/")
        public Mono<Void> createDirectory(@HostParam(value="$host") String var1, @PathParam(value="path") String var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "If-Match: *"})
        @Delete(value="admin/vfs/{path}")
        public Mono<Void> deleteFile(@HostParam(value="$host") String var1, @PathParam(value="path") String var2);
    }
}

