/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.core;

import com.microsoft.azure.storage.ServiceClient;
import com.microsoft.azure.storage.SharedAccessHeaders;
import com.microsoft.azure.storage.SharedAccessPolicy;
import com.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.core.Logger;
import com.microsoft.azure.storage.core.PathUtility;
import com.microsoft.azure.storage.core.StorageCredentialsHelper;
import com.microsoft.azure.storage.core.UriQueryBuilder;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.queue.SharedAccessQueuePolicy;
import com.microsoft.azure.storage.table.SharedAccessTablePolicy;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SharedAccessSignatureHelper {
    public static UriQueryBuilder generateSharedAccessSignatureForBlobAndFile(SharedAccessPolicy policy, SharedAccessHeaders headers, String groupPolicyIdentifier, String resourceType, String signature) throws StorageException {
        Utility.assertNotNullOrEmpty("resourceType", resourceType);
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHelper(policy, null, null, null, null, groupPolicyIdentifier, resourceType, null, signature, headers);
    }

    public static UriQueryBuilder generateSharedAccessSignatureForQueue(SharedAccessQueuePolicy policy, String groupPolicyIdentifier, String signature) throws StorageException {
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHelper(policy, null, null, null, null, groupPolicyIdentifier, null, null, signature, null);
    }

    public static UriQueryBuilder generateSharedAccessSignatureForTable(SharedAccessTablePolicy policy, String startPartitionKey, String startRowKey, String endPartitionKey, String endRowKey, String accessPolicyIdentifier, String tableName, String signature) throws StorageException {
        Utility.assertNotNull("tableName", tableName);
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHelper(policy, startPartitionKey, startRowKey, endPartitionKey, endRowKey, accessPolicyIdentifier, null, tableName, signature, null);
    }

    public static String generateSharedAccessSignatureHashForBlobAndFile(SharedAccessPolicy policy, SharedAccessHeaders headers, String accessPolicyIdentifier, String resourceName, ServiceClient client) throws InvalidKeyException, StorageException {
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHashForBlobAndFile(policy, resourceName, accessPolicyIdentifier, client, headers);
    }

    public static String generateSharedAccessSignatureHashForQueue(SharedAccessQueuePolicy policy, String accessPolicyIdentifier, String resourceName, ServiceClient client) throws InvalidKeyException, StorageException {
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHashForQueueAndTable(policy, resourceName, accessPolicyIdentifier, false, null, null, null, null, client);
    }

    public static String generateSharedAccessSignatureHashForTable(SharedAccessTablePolicy policy, String accessPolicyIdentifier, String resourceName, String startPartitionKey, String startRowKey, String endPartitionKey, String endRowKey, ServiceClient client) throws InvalidKeyException, StorageException {
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHashForQueueAndTable(policy, resourceName, accessPolicyIdentifier, true, startPartitionKey, startRowKey, endPartitionKey, endRowKey, client);
    }

    public static StorageCredentialsSharedAccessSignature parseQuery(StorageUri completeUri) throws StorageException {
        HashMap<String, String[]> queryParameters = PathUtility.parseQueryString(completeUri.getQuery());
        return SharedAccessSignatureHelper.parseQuery(queryParameters);
    }

    public static StorageCredentialsSharedAccessSignature parseQuery(HashMap<String, String[]> queryParams) throws StorageException {
        boolean sasParameterFound = false;
        ArrayList<String> removeList = new ArrayList<String>();
        for (Map.Entry<String, String[]> entry : queryParams.entrySet()) {
            String lowerKey = entry.getKey().toLowerCase(Utility.LOCALE_US);
            if (lowerKey.equals("sig")) {
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("comp")) {
                removeList.add(entry.getKey());
                continue;
            }
            if (lowerKey.equals("restype")) {
                removeList.add(entry.getKey());
                continue;
            }
            if (lowerKey.equals("snapshot")) {
                removeList.add(entry.getKey());
                continue;
            }
            if (!lowerKey.equals("api-version")) continue;
            removeList.add(entry.getKey());
        }
        for (String removeParam : removeList) {
            queryParams.remove(removeParam);
        }
        if (sasParameterFound) {
            UriQueryBuilder builder = new UriQueryBuilder();
            StringBuilder values = new StringBuilder();
            for (Map.Entry<String, String[]> entry : queryParams.entrySet()) {
                values.setLength(0);
                for (int i = 0; i < entry.getValue().length; ++i) {
                    values.append(entry.getValue()[i]);
                    values.append(',');
                }
                values.deleteCharAt(values.length() - 1);
                SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, entry.getKey().toLowerCase(), values.toString());
            }
            return new StorageCredentialsSharedAccessSignature(builder.toString());
        }
        return null;
    }

    private static void addIfNotNullOrEmpty(UriQueryBuilder builder, String name, String val) throws StorageException {
        if (!Utility.isNullOrEmpty(val)) {
            builder.add(name, val);
        }
    }

    private static UriQueryBuilder generateSharedAccessSignatureHelper(SharedAccessPolicy policy, String startPartitionKey, String startRowKey, String endPartitionKey, String endRowKey, String accessPolicyIdentifier, String resourceType, String tableName, String signature, SharedAccessHeaders headers) throws StorageException {
        Utility.assertNotNull("signature", signature);
        String permissions = null;
        Date startTime = null;
        Date expiryTime = null;
        if (policy != null) {
            permissions = policy.permissionsToString();
            startTime = policy.getSharedAccessStartTime();
            expiryTime = policy.getSharedAccessExpiryTime();
        }
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("sv", "2015-02-21");
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "sp", permissions);
        String startString = Utility.getUTCTimeOrEmpty(startTime);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "st", startString);
        String stopString = Utility.getUTCTimeOrEmpty(expiryTime);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "se", stopString);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "spk", startPartitionKey);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "srk", startRowKey);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "epk", endPartitionKey);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "erk", endRowKey);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "si", accessPolicyIdentifier);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "sr", resourceType);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "tn", tableName);
        if (headers != null) {
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "rscc", headers.getCacheControl());
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "rsct", headers.getContentType());
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "rsce", headers.getContentEncoding());
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "rscl", headers.getContentLanguage());
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "rscd", headers.getContentDisposition());
        }
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "sig", signature);
        return builder;
    }

    private static String generateSharedAccessSignatureHashForBlobAndFile(SharedAccessPolicy policy, String resourceName, String accessPolicyIdentifier, ServiceClient client, SharedAccessHeaders headers) throws InvalidKeyException, StorageException {
        Utility.assertNotNullOrEmpty("resourceName", resourceName);
        Utility.assertNotNull("client", client);
        String permissions = null;
        Date startTime = null;
        Date expiryTime = null;
        if (policy != null) {
            permissions = policy.permissionsToString();
            startTime = policy.getSharedAccessStartTime();
            expiryTime = policy.getSharedAccessExpiryTime();
        }
        String cacheControl = null;
        String contentDisposition = null;
        String contentEncoding = null;
        String contentLanguage = null;
        String contentType = null;
        if (headers != null) {
            cacheControl = headers.getCacheControl();
            contentDisposition = headers.getContentDisposition();
            contentEncoding = headers.getContentEncoding();
            contentLanguage = headers.getContentLanguage();
            contentType = headers.getContentType();
        }
        String stringToSign = String.format("%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s", permissions == null ? "" : permissions, Utility.getUTCTimeOrEmpty(startTime), Utility.getUTCTimeOrEmpty(expiryTime), resourceName, accessPolicyIdentifier == null ? "" : accessPolicyIdentifier, "2015-02-21", cacheControl == null ? "" : cacheControl, contentDisposition == null ? "" : contentDisposition, contentEncoding == null ? "" : contentEncoding, contentLanguage == null ? "" : contentLanguage, contentType == null ? "" : contentType);
        stringToSign = Utility.safeDecode(stringToSign);
        String signature = StorageCredentialsHelper.computeHmac256(client.getCredentials(), stringToSign);
        Logger.trace(null, "Signing %s", (Object)stringToSign);
        return signature;
    }

    private static String generateSharedAccessSignatureHashForQueueAndTable(SharedAccessPolicy policy, String resourceName, String accessPolicyIdentifier, boolean useTableSas, String startPartitionKey, String startRowKey, String endPartitionKey, String endRowKey, ServiceClient client) throws InvalidKeyException, StorageException {
        Utility.assertNotNullOrEmpty("resourceName", resourceName);
        Utility.assertNotNull("client", client);
        String permissions = null;
        Date startTime = null;
        Date expiryTime = null;
        if (policy != null) {
            permissions = policy.permissionsToString();
            startTime = policy.getSharedAccessStartTime();
            expiryTime = policy.getSharedAccessExpiryTime();
        }
        String stringToSign = String.format("%s\n%s\n%s\n%s\n%s\n%s", permissions == null ? "" : permissions, Utility.getUTCTimeOrEmpty(startTime), Utility.getUTCTimeOrEmpty(expiryTime), resourceName, accessPolicyIdentifier == null ? "" : accessPolicyIdentifier, "2015-02-21");
        if (useTableSas) {
            stringToSign = String.format("%s\n%s\n%s\n%s\n%s", stringToSign, startPartitionKey == null ? "" : startPartitionKey, startRowKey == null ? "" : startRowKey, endPartitionKey == null ? "" : endPartitionKey, endRowKey == null ? "" : endRowKey);
        }
        stringToSign = Utility.safeDecode(stringToSign);
        String signature = StorageCredentialsHelper.computeHmac256(client.getCredentials(), stringToSign);
        Logger.trace(null, "Signing %s", (Object)stringToSign);
        return signature;
    }

    private SharedAccessSignatureHelper() {
    }
}

