/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.jms;

import com.microsoft.azure.servicebus.jms.ServiceBusJmsConnectionFactorySettings;
import com.microsoft.azure.servicebus.primitives.ConnectionStringBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.apache.qpid.jms.JmsConnectionExtensions;
import org.apache.qpid.jms.JmsConnectionFactory;

public class ServiceBusJmsConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory {
    private static final int MaxCustomUserAgentLength = 128;
    private final JmsConnectionFactory factory;
    private ConnectionStringBuilder builder;
    private String customUserAgent;

    public ServiceBusJmsConnectionFactory(String connectionString, ServiceBusJmsConnectionFactorySettings settings) {
        this(new ConnectionStringBuilder(connectionString), settings);
    }

    public ServiceBusJmsConnectionFactory(ConnectionStringBuilder connectionStringBuilder, ServiceBusJmsConnectionFactorySettings settings) {
        this(connectionStringBuilder.getSasKeyName(), connectionStringBuilder.getSasKey(), connectionStringBuilder.getEndpoint().getHost(), settings);
        this.builder = connectionStringBuilder;
    }

    public ServiceBusJmsConnectionFactory(String sasKeyName, String sasKey, String host, ServiceBusJmsConnectionFactorySettings settings) {
        if (sasKeyName == null || sasKeyName == null || host == null) {
            throw new IllegalArgumentException("SAS Key, SAS KeyName and the host cannot be null for a ServiceBus connection factory.");
        }
        if (settings == null) {
            settings = new ServiceBusJmsConnectionFactorySettings();
        }
        String serviceBusQuery = settings.getServiceBusQuery();
        String destinationUri = "amqps://" + host + serviceBusQuery;
        if (settings.shouldReconnect()) {
            destinationUri = this.getReconnectUri(destinationUri, settings);
        }
        this.factory = new JmsConnectionFactory(sasKeyName, sasKey, destinationUri);
        this.factory.setExtension(JmsConnectionExtensions.AMQP_OPEN_PROPERTIES.toString(), (connection, uri) -> {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("com.microsoft:is-client-provider", true);
            String servicebusJmsVersion = "";
            Properties applicationProperties = new Properties();
            try {
                applicationProperties.load(this.getClass().getClassLoader().getResourceAsStream("application.properties"));
                servicebusJmsVersion = applicationProperties.getProperty("azure.servicebus.jms.version");
            }
            catch (IOException e) {
                servicebusJmsVersion = "unknown";
            }
            StringBuilder userAgent = new StringBuilder("ServiceBusJms");
            userAgent.append("-").append(servicebusJmsVersion);
            if (this.customUserAgent != null && this.customUserAgent.length() > 0) {
                userAgent.append("/").append(this.customUserAgent);
            }
            properties.put("user-agent", userAgent.toString());
            return properties;
        });
    }

    JmsConnectionFactory getConectionFactory() {
        return this.factory;
    }

    public ConnectionStringBuilder getConnectionStringBuilder() {
        return this.builder;
    }

    public String getClientId() {
        return this.factory.getClientID();
    }

    public void setClientId(String clientId) {
        this.factory.setClientID(clientId);
    }

    protected String getCustomUserAgent() {
        return this.customUserAgent;
    }

    protected void setCustomUserAgent(String customUserAgent) {
        if (customUserAgent != null && customUserAgent.length() > 128) {
            throw new IllegalArgumentException("The length of the custom userAgent cannot exceed 128");
        }
        this.customUserAgent = customUserAgent;
    }

    public Connection createConnection() throws JMSException {
        return this.factory.createConnection();
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        return this.factory.createConnection(userName, password);
    }

    public JMSContext createContext() {
        return this.factory.createContext();
    }

    public JMSContext createContext(int sessionMode) {
        return this.factory.createContext(sessionMode);
    }

    public JMSContext createContext(String userName, String password) {
        return this.factory.createContext(userName, password);
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        return this.factory.createContext(userName, password, sessionMode);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.factory.createTopicConnection();
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return this.factory.createTopicConnection(userName, password);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.factory.createQueueConnection();
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return this.factory.createQueueConnection(userName, password);
    }

    private String getReconnectUri(String originalHost, ServiceBusJmsConnectionFactorySettings settings) {
        StringBuilder builder = new StringBuilder("failover:(");
        builder.append(originalHost);
        String[] reconnectHosts = settings.getReconnectHosts();
        if (settings.getReconnectHosts() != null) {
            String serviceBusQuery = settings.getServiceBusQuery();
            for (String reconnectHost : reconnectHosts) {
                builder.append(",");
                builder.append("amqps://");
                builder.append(reconnectHost);
                builder.append(serviceBusQuery);
            }
        }
        builder.append(")");
        builder.append(settings.getReconnectQuery());
        return builder.toString();
    }
}

