/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.jms;

import com.microsoft.azure.servicebus.jms.ServiceBusJmsConnectionFactory;
import com.microsoft.azure.servicebus.jms.ServiceBusJmsConnectionFactorySettings;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.Topic;

public class Sandbox {
    static Connection connection;

    public static void main(String[] args) throws Exception {
        ServiceBusJmsConnectionFactorySettings settings = new ServiceBusJmsConnectionFactorySettings();
        settings.setShouldReconnect(true);
        settings.setMaxReconnectAttempts(30);
        settings.setInitialReconnectDelay(100L);
        String[] hosts = new String[]{"contoso2.servicebus.onebox.windows-int.net", "bailiu-servicebus-test-premium.servicebus.windows.net"};
        settings.setReconnectHosts(hosts);
        settings.setReconnectRandomize(true);
        ServiceBusJmsConnectionFactory cf = new ServiceBusJmsConnectionFactory("Endpoint=sb://contoso.servicebus.onebox.windows-int.net/;SharedAccessKeyName=DefaultNamespaceSasAllKeyName;SharedAccessKey=8864/auVd3qDC75iTjBL1GJ4D2oXC6bIttRd0jzDZ+g=", settings);
        Connection connection = cf.createConnection();
        Session session = connection.createSession();
        String topicName = "mytopic-" + UUID.randomUUID().toString().substring(0, 10);
        Topic t = session.createTopic(topicName);
        session.createProducer((Destination)t);
        session.createConsumer((Destination)t);
        System.out.println("Start Sleeping");
        Thread.sleep(330000L);
        System.out.println("Stop Sleeping");
        connection.close();
    }

    static void mytest() throws FileNotFoundException {
        long total = 0L;
        long lineNum = 0L;
        File mytxt = new File("mytxt.txt");
        Scanner myReader = new Scanner(mytxt);
        Pattern p = Pattern.compile("(?<=returned )(.*)(?= available messages)");
        while (myReader.hasNextLine()) {
            String data = myReader.nextLine();
            Matcher m = p.matcher(data);
            boolean found = m.find();
            String filtered = m.group(1);
            System.out.println("Line " + lineNum++ + ": " + filtered);
            total += Long.valueOf(filtered).longValue();
        }
        System.out.println("Total: " + total);
        myReader.close();
    }

    static void tempQueue() throws Exception {
        Session session = connection.createSession();
        TemporaryQueue q = session.createTemporaryQueue();
        MessageConsumer consumer = session.createConsumer((Destination)q);
        MessageProducer producer = session.createProducer((Destination)q);
        producer.send(session.createMessage());
        System.out.println("====sleep start====");
        Thread.sleep(300000L);
        System.out.println("====sleep end====");
        Message message = consumer.receive(2000L);
        if (message == null) {
            throw new JMSException("null message");
        }
        connection.close();
    }

    static void transactedSession() throws Exception {
        Session session = connection.createSession(true, 2);
        Queue q = session.createQueue("myqueue");
        MessageConsumer consumer = session.createConsumer((Destination)q);
        MessageProducer producer = session.createProducer((Destination)q);
        producer.send(session.createMessage());
        session.commit();
        Message message = consumer.receive();
        System.out.println("====sleep start====");
        Thread.sleep(300000L);
        System.out.println("====sleep end====");
        message.acknowledge();
        session.commit();
        connection.close();
    }
}

