/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.dns.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.dns.AaaaRecord;
import com.microsoft.azure.management.dns.AaaaRecordSet;
import com.microsoft.azure.management.dns.RecordType;
import com.microsoft.azure.management.dns.implementation.DnsRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.DnsZoneImpl;
import com.microsoft.azure.management.dns.implementation.RecordSetInner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@LangDefinition
class AaaaRecordSetImpl
extends DnsRecordSetImpl
implements AaaaRecordSet {
    AaaaRecordSetImpl(String name, DnsZoneImpl parent, RecordSetInner innerModel) {
        super(name, RecordType.AAAA.toString(), parent, innerModel);
    }

    static AaaaRecordSetImpl newRecordSet(String name, DnsZoneImpl parent) {
        return new AaaaRecordSetImpl(name, parent, new RecordSetInner().withAaaaRecords(new ArrayList<AaaaRecord>()));
    }

    @Override
    public List<String> ipv6Addresses() {
        ArrayList<String> ipv6Addresses = new ArrayList<String>();
        if (((RecordSetInner)this.inner()).aaaaRecords() != null) {
            for (AaaaRecord aaaaRecord : ((RecordSetInner)this.inner()).aaaaRecords()) {
                ipv6Addresses.add(aaaaRecord.ipv6Address());
            }
        }
        return Collections.unmodifiableList(ipv6Addresses);
    }

    @Override
    protected RecordSetInner prepareForUpdate(RecordSetInner resource) {
        if (((RecordSetInner)this.inner()).aaaaRecords() != null && ((RecordSetInner)this.inner()).aaaaRecords().size() > 0) {
            if (resource.aaaaRecords() == null) {
                resource.withAaaaRecords(new ArrayList<AaaaRecord>());
            }
            resource.aaaaRecords().addAll(((RecordSetInner)this.inner()).aaaaRecords());
            ((RecordSetInner)this.inner()).aaaaRecords().clear();
        }
        if (this.recordSetRemoveInfo.aaaaRecords().size() > 0) {
            if (resource.aaaaRecords() != null) {
                block0: for (AaaaRecord recordToRemove : this.recordSetRemoveInfo.aaaaRecords()) {
                    for (AaaaRecord record : resource.aaaaRecords()) {
                        if (!record.ipv6Address().equalsIgnoreCase(recordToRemove.ipv6Address())) continue;
                        resource.aaaaRecords().remove(record);
                        continue block0;
                    }
                }
            }
            this.recordSetRemoveInfo.aaaaRecords().clear();
        }
        return resource;
    }
}

