/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerinstance.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.containerinstance.implementation.ContainerExecRequestInner;
import com.microsoft.azure.management.containerinstance.implementation.ContainerExecResponseInner;
import com.microsoft.azure.management.containerinstance.implementation.ContainerInstanceManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class StartContainersInner {
    private StartContainersService service;
    private ContainerInstanceManagementClientImpl client;

    public StartContainersInner(Retrofit retrofit, ContainerInstanceManagementClientImpl client) {
        this.service = (StartContainersService)retrofit.create(StartContainersService.class);
        this.client = client;
    }

    public ContainerExecResponseInner launchExec(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequestInner containerExecRequest) {
        return (ContainerExecResponseInner)((ServiceResponse)this.launchExecWithServiceResponseAsync(resourceGroupName, containerGroupName, containerName, containerExecRequest).toBlocking().single()).body();
    }

    public ServiceFuture<ContainerExecResponseInner> launchExecAsync(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequestInner containerExecRequest, ServiceCallback<ContainerExecResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.launchExecWithServiceResponseAsync(resourceGroupName, containerGroupName, containerName, containerExecRequest), serviceCallback);
    }

    public Observable<ContainerExecResponseInner> launchExecAsync(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequestInner containerExecRequest) {
        return this.launchExecWithServiceResponseAsync(resourceGroupName, containerGroupName, containerName, containerExecRequest).map((Func1)new Func1<ServiceResponse<ContainerExecResponseInner>, ContainerExecResponseInner>(){

            public ContainerExecResponseInner call(ServiceResponse<ContainerExecResponseInner> response) {
                return (ContainerExecResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ContainerExecResponseInner>> launchExecWithServiceResponseAsync(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequestInner containerExecRequest) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (containerGroupName == null) {
            throw new IllegalArgumentException("Parameter containerGroupName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (containerExecRequest == null) {
            throw new IllegalArgumentException("Parameter containerExecRequest is required and cannot be null.");
        }
        Validator.validate((Object)containerExecRequest);
        return this.service.launchExec(this.client.subscriptionId(), resourceGroupName, containerGroupName, containerName, this.client.apiVersion(), containerExecRequest, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ContainerExecResponseInner>>>(){

            public Observable<ServiceResponse<ContainerExecResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StartContainersInner.this.launchExecDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ContainerExecResponseInner> launchExecDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ContainerExecResponseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface StartContainersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.StartContainers launchExec"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}/containers/{containerName}/exec")
        public Observable<Response<ResponseBody>> launchExec(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="containerGroupName") String var3, @Path(value="containerName") String var4, @Query(value="api-version") String var5, @Body ContainerExecRequestInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);
    }
}

