/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.maven.common.messager;

import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.action.AzureActionManager;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessagerProvider;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessage;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenAzureMessager
implements IAzureMessager,
IAzureMessage.ValueDecorator {
    private static final Logger log = LoggerFactory.getLogger(MavenAzureMessager.class);

    public boolean show(IAzureMessage message) {
        Stream<AzureActionManager.DummyOpenUrlAction> actions = Arrays.stream((Object[])ObjectUtils.firstNonNull((Object[])new Action[][]{message.getActions(), new Action[0]})).filter(action -> action instanceof AzureActionManager.DummyOpenUrlAction).map(a -> (AzureActionManager.DummyOpenUrlAction)a);
        switch (message.getType()) {
            case ALERT: 
            case CONFIRM: 
            case WARNING: {
                log.warn(message.getContent());
                actions.forEach(action -> log.warn("* " + action.toString((IAzureMessage.ValueDecorator)this)));
                return true;
            }
            case ERROR: {
                log.error(message.getContent(), (Throwable)message.getPayload());
                actions.forEach(action -> log.error("* " + action.toString((IAzureMessage.ValueDecorator)this)));
                return true;
            }
            case DEBUG: {
                System.out.println(message.getContent());
                actions.forEach(action -> log.debug("* " + action.toString((IAzureMessage.ValueDecorator)this)));
                return true;
            }
        }
        log.info(message.getContent());
        actions.forEach(action -> log.info("* " + action.toString((IAzureMessage.ValueDecorator)this)));
        return true;
    }

    public String decorateValue(@Nonnull Object p, @Nullable IAzureMessage message) {
        return TextUtils.cyan((String)p.toString());
    }

    public static class Provider
    implements AzureMessagerProvider {
        @Nonnull
        public MavenAzureMessager getMessager() {
            return new MavenAzureMessager();
        }
    }
}

