/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.management.AzureEnvironment;
import com.azure.identity.DeviceCodeInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.applicationinsights.internal.channel.common.ApacheSenderFactory;
import com.microsoft.azure.management.resources.Subscription;
import com.microsoft.azure.maven.exception.MavenDecryptException;
import com.microsoft.azure.maven.model.MavenAuthConfiguration;
import com.microsoft.azure.maven.model.SubscriptionOption;
import com.microsoft.azure.maven.utils.CustomTextIoStringListReader;
import com.microsoft.azure.maven.utils.MavenAuthUtils;
import com.microsoft.azure.maven.utils.ProxyUtils;
import com.microsoft.azure.maven.utils.SystemPropertyUtils;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.auth.AzureCloud;
import com.microsoft.azure.toolkit.lib.auth.core.devicecode.DeviceCodeAccount;
import com.microsoft.azure.toolkit.lib.auth.exception.AzureLoginException;
import com.microsoft.azure.toolkit.lib.auth.exception.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.auth.exception.LoginFailureException;
import com.microsoft.azure.toolkit.lib.auth.model.AuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.model.AuthType;
import com.microsoft.azure.toolkit.lib.auth.util.AzureEnvironmentUtils;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.logging.Log;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.proxy.ProxyManager;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemeter;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemetryClient;
import com.microsoft.azure.toolkit.lib.common.utils.InstallationIdUtils;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import com.microsoft.azure.toolkit.maven.common.messager.MavenAzureMessager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.TextIO;
import org.beryx.textio.TextIoFactory;
import reactor.core.publisher.Mono;

public abstract class AbstractAzureMojo
extends AbstractMojo {
    public static final String PLUGIN_NAME_KEY = "pluginName";
    public static final String PLUGIN_VERSION_KEY = "pluginVersion";
    public static final String INSTALLATION_ID_KEY = "installationId";
    public static final String SESSION_ID_KEY = "sessionId";
    public static final String SUBSCRIPTION_ID_KEY = "subscriptionId";
    protected static final String DEPLOY = "deploy";
    private static final String AUTH_TYPE = "authType";
    private static final String AUTH_METHOD = "authMethod";
    private static final String TELEMETRY_NOT_ALLOWED = "TelemetryNotAllowed";
    private static final String INIT_FAILURE = "InitFailure";
    private static final String AZURE_INIT_FAIL = "Failed to authenticate with Azure. Please check your configuration.";
    private static final String ERROR_MESSAGE = "error.message";
    private static final String ERROR_STACK = "error.stack";
    private static final String ERROR_CLASSNAME = "error.class_name";
    private static final String JVM_UP_TIME = "jvmUpTime";
    private static final String CONFIGURATION_PATH = Paths.get(System.getProperty("user.home"), ".azure", "mavenplugins.properties").toString();
    private static final String FIRST_RUN_KEY = "first.run";
    private static final String PRIVACY_STATEMENT = "\nData/Telemetry\n---------\nThis project collects usage data and sends it to Microsoft to help improve our products and services.\nRead Microsoft's privacy statement to learn more: https://privacy.microsoft.com/en-us/privacystatement.\n\nYou can change your telemetry configuration through 'allowTelemetry' property.\nFor more information, please go to https://aka.ms/azure-maven-config.\n";
    protected static final String SUBSCRIPTION_TEMPLATE = "Subscription: %s(%s)";
    protected static final String USING_AZURE_ENVIRONMENT = "Using Azure environment: %s.";
    protected static final String SUBSCRIPTION_NOT_FOUND = "Subscription %s was not found in current account.";
    private static final String INVALID_AZURE_ENVIRONMENT = "Invalid environment string '%s', please replace it with one of \"Azure\", \"AzureChina\", \"AzureGermany\", \"AzureUSGovernment\",.";
    private static final String AZURE_ENVIRONMENT = "azureEnvironment";
    private static final String PROXY = "proxy";
    @JsonIgnore
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @JsonIgnore
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @JsonIgnore
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    protected File buildDirectory;
    @JsonIgnore
    @Parameter(defaultValue="${plugin}", readonly=true, required=true)
    protected PluginDescriptor plugin;
    @JsonIgnore
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    protected Settings settings;
    @JsonIgnore
    @Component(role=MavenResourcesFiltering.class, hint="default")
    protected MavenResourcesFiltering mavenResourcesFiltering;
    @JsonProperty
    @Parameter
    protected String subscriptionId = "";
    @JsonProperty
    @Parameter(property="allowTelemetry", defaultValue="true")
    protected boolean allowTelemetry;
    @JsonProperty
    @Parameter(property="failsOnError", defaultValue="true")
    protected boolean failsOnError;
    @JsonProperty
    @Parameter(property="httpProxyHost")
    protected String httpProxyHost;
    @JsonProperty
    @Parameter(property="httpProxyPort")
    protected String httpProxyPort;
    @JsonProperty
    @Parameter(property="authType")
    protected String authType;
    @JsonProperty
    @Parameter(property="auth")
    protected MavenAuthConfiguration auth;
    @JsonIgnore
    @Component
    protected SettingsDecrypter settingsDecrypter;
    @JsonIgnore
    private Account azureAccount;
    @JsonIgnore
    private com.microsoft.azure.management.Azure azure;
    @JsonIgnore
    protected AzureTelemetryClient telemetryProxy;
    @JsonIgnore
    protected Map<String, String> telemetries = new HashMap<String, String>();
    @JsonIgnore
    private final String sessionId = UUID.randomUUID().toString();
    @JsonIgnore
    private final String installationId = InstallationIdUtils.getHashMac();

    public String getBuildDirectoryAbsolutePath() {
        return this.buildDirectory.getAbsolutePath();
    }

    public String getInstallationId() {
        return this.installationId == null ? "" : this.installationId;
    }

    public String getPluginName() {
        return this.plugin.getArtifactId();
    }

    public String getPluginVersion() {
        return this.plugin.getVersion();
    }

    public String getUserAgent() {
        return this.isAllowTelemetry() ? String.format("%s/%s %s:%s %s:%s", this.getPluginName(), this.getPluginVersion(), INSTALLATION_ID_KEY, this.getInstallationId(), SESSION_ID_KEY, this.getSessionId()) : String.format("%s/%s", this.getPluginName(), this.getPluginVersion());
    }

    public int getHttpProxyPort() {
        return NumberUtils.toInt((String)this.httpProxyPort, (int)0);
    }

    protected String getAuthType() {
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.auth == null ? null : this.auth.getType(), this.authType});
    }

    protected String selectSubscription(com.microsoft.azure.toolkit.lib.common.model.Subscription[] subscriptions) throws AzureExecutionException {
        if (subscriptions.length == 0) {
            throw new AzureExecutionException("Cannot find any subscriptions in current account.");
        }
        if (subscriptions.length == 1) {
            Log.info((String)String.format("There is only one subscription '%s' in your account, will use it automatically.", TextUtils.blue((String)SubscriptionOption.getSubscriptionName(subscriptions[0]))));
            return subscriptions[0].getId();
        }
        List wrapSubs = Arrays.stream(subscriptions).map(SubscriptionOption::new).sorted().collect(Collectors.toList());
        SubscriptionOption defaultValue = (SubscriptionOption)wrapSubs.get(0);
        TextIO textIO = TextIoFactory.getTextIO();
        SubscriptionOption subscriptionOptionSelected = (SubscriptionOption)((GenericInputReader)((GenericInputReader)new CustomTextIoStringListReader(() -> ((TextIO)textIO).getTextTerminal(), null).withCustomPrompt(String.format("Please choose a subscription%s: ", AbstractAzureMojo.highlightDefaultValue(defaultValue == null ? null : defaultValue.getSubscriptionName()))).withNumberedPossibleValues(wrapSubs)).withDefaultValue((Object)defaultValue)).read(new String[]{"Available subscriptions:"});
        if (subscriptionOptionSelected == null) {
            throw new AzureExecutionException("You must select a subscription.");
        }
        return subscriptionOptionSelected.getSubscription().getId();
    }

    protected Account getAzureAccount() throws MavenDecryptException, AzureExecutionException, LoginFailureException {
        if (this.azureAccount == null) {
            MavenAuthConfiguration mavenAuthConfiguration = this.auth == null ? new MavenAuthConfiguration() : this.auth;
            mavenAuthConfiguration.setType(this.getAuthType());
            SystemPropertyUtils.injectCommandLineParameter("auth", mavenAuthConfiguration, MavenAuthConfiguration.class);
            Azure.az().config().setUserAgent(this.getUserAgent());
            this.azureAccount = this.login(MavenAuthUtils.buildAuthConfiguration(this.session, this.settingsDecrypter, mavenAuthConfiguration));
        }
        return this.azureAccount;
    }

    protected void selectSubscription() {
        Account account = ((AzureAccount)Azure.az(AzureAccount.class)).account();
        List subscriptions = account.getSubscriptions();
        String targetSubscriptionId = this.getTargetSubscriptionId(this.getSubscriptionId(), subscriptions, account.getSelectedSubscriptions());
        AbstractAzureMojo.checkSubscription(subscriptions, targetSubscriptionId);
        account.selectSubscription(Collections.singletonList(targetSubscriptionId));
        com.microsoft.azure.toolkit.lib.common.model.Subscription subscription = account.getSubscription(targetSubscriptionId);
        Log.info((String)String.format(SUBSCRIPTION_TEMPLATE, TextUtils.cyan((String)subscription.getName()), TextUtils.cyan((String)subscription.getId())));
        this.subscriptionId = targetSubscriptionId;
    }

    protected Account login(@Nonnull AuthConfiguration auth) {
        AbstractAzureMojo.promptAzureEnvironment(auth.getEnvironment());
        MavenAuthUtils.disableIdentityLogs();
        AbstractAzureMojo.accountLogin(auth);
        Account account = ((AzureAccount)Azure.az(AzureAccount.class)).account();
        boolean isInteractiveLogin = account.getAuthType() == AuthType.OAUTH2 || account.getAuthType() == AuthType.DEVICE_CODE;
        AzureEnvironment env = account.getEnvironment();
        String environmentName = AzureEnvironmentUtils.azureEnvironmentToString((AzureEnvironment)env);
        if (env != AzureEnvironment.AZURE && env != auth.getEnvironment()) {
            Log.prompt((String)String.format(USING_AZURE_ENVIRONMENT, TextUtils.cyan((String)environmentName)));
        }
        AbstractAzureMojo.printCredentialDescription(account, isInteractiveLogin);
        this.telemetryProxy.addDefaultProperty(AUTH_TYPE, this.getAuthType());
        this.telemetryProxy.addDefaultProperty(AUTH_METHOD, this.getActualAuthType());
        this.telemetryProxy.addDefaultProperty(AZURE_ENVIRONMENT, environmentName);
        return account;
    }

    private static Account accountLogin(@Nonnull AuthConfiguration auth) {
        if (auth.getEnvironment() != null) {
            ((AzureCloud)Azure.az(AzureCloud.class)).set(auth.getEnvironment());
        }
        if (auth.getType() == null || auth.getType() == AuthType.AUTO) {
            if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{auth.getCertificate(), auth.getCertificatePassword(), auth.getKey()})) {
                Account account = (Account)AbstractAzureMojo.findFirstAvailableAccount().block();
                AbstractAzureMojo.promptForOAuthOrDeviceCodeLogin(account.getAuthType());
                return AbstractAzureMojo.handleDeviceCodeAccount((Account)((AzureAccount)Azure.az(AzureAccount.class)).loginAsync(account, false).block());
            }
            return AbstractAzureMojo.doServicePrincipalLogin(auth);
        }
        AbstractAzureMojo.promptForOAuthOrDeviceCodeLogin(auth.getType());
        return AbstractAzureMojo.handleDeviceCodeAccount((Account)((AzureAccount)Azure.az(AzureAccount.class)).loginAsync(auth, false).block());
    }

    private static Account handleDeviceCodeAccount(Account account) {
        if (account instanceof DeviceCodeAccount) {
            DeviceCodeAccount deviceCodeAccount = (DeviceCodeAccount)account;
            DeviceCodeInfo challenge = deviceCodeAccount.getDeviceCode();
            System.out.println(StringUtils.replace((String)challenge.getMessage(), (String)challenge.getUserCode(), (String)TextUtils.cyan((String)challenge.getUserCode())));
        }
        return (Account)account.continueLogin().block();
    }

    private static void promptAzureEnvironment(AzureEnvironment env) {
        if (env != null && env != AzureEnvironment.AZURE) {
            Log.prompt((String)String.format("Auth environment: %s", TextUtils.cyan((String)AzureEnvironmentUtils.azureEnvironmentToString((AzureEnvironment)env))));
        }
    }

    private static void promptForOAuthOrDeviceCodeLogin(AuthType authType) {
        if (authType == AuthType.OAUTH2 || authType == AuthType.DEVICE_CODE) {
            Log.prompt((String)String.format("Auth type: %s", TextUtils.cyan((String)authType.toString())));
        }
    }

    private static Mono<Account> findFirstAvailableAccount() {
        List accounts = ((AzureAccount)Azure.az(AzureAccount.class)).accounts();
        if (accounts.isEmpty()) {
            return Mono.error((Throwable)new AzureToolkitAuthenticationException("there are no subscriptions available."));
        }
        Mono current = AbstractAzureMojo.checkAccountAvailable((Account)accounts.get(0));
        for (int i = 1; i < accounts.size(); ++i) {
            Account ac = (Account)accounts.get(i);
            current = current.onErrorResume(e -> AbstractAzureMojo.checkAccountAvailable(ac));
        }
        return current;
    }

    private static Account doServicePrincipalLogin(AuthConfiguration auth) {
        auth.setType(AuthType.SERVICE_PRINCIPAL);
        return ((AzureAccount)Azure.az(AzureAccount.class)).login(auth).account();
    }

    private static Mono<Account> checkAccountAvailable(Account account) {
        return account.checkAvailable().map(avail -> {
            if (avail.booleanValue()) {
                return account;
            }
            throw new AzureToolkitAuthenticationException(String.format("auth type: %s is not available", account.getAuthType()));
        });
    }

    protected static void printCredentialDescription(Account account, boolean skipType) {
        if (skipType) {
            List selectedSubscriptions;
            if (CollectionUtils.isNotEmpty((Collection)account.getSubscriptions()) && (selectedSubscriptions = account.getSelectedSubscriptions()) != null && selectedSubscriptions.size() == 1) {
                System.out.printf("Default subscription: %s(%s)%n", TextUtils.cyan((String)((com.microsoft.azure.toolkit.lib.common.model.Subscription)selectedSubscriptions.get(0)).getName()), TextUtils.cyan((String)((com.microsoft.azure.toolkit.lib.common.model.Subscription)selectedSubscriptions.get(0)).getId()));
            }
            if (StringUtils.isNotEmpty((CharSequence)account.getEntity().getEmail())) {
                System.out.printf("Username: %s%n", TextUtils.cyan((String)account.getEntity().getEmail()));
            }
        } else {
            System.out.println(account.toString());
        }
    }

    protected void initTelemetryProxy() {
        Map<String, String> properties = this.getTelemetryProperties();
        this.telemetryProxy = new AzureTelemetryClient(properties);
        AzureTelemeter.setClient((AzureTelemetryClient)this.telemetryProxy);
        AzureTelemeter.setEventNamePrefix((String)"AzurePlugin.Maven");
        if (!this.isAllowTelemetry()) {
            this.telemetryProxy.trackEvent(TELEMETRY_NOT_ALLOWED);
            this.telemetryProxy.disable();
        }
    }

    protected static void printCurrentSubscription(com.microsoft.azure.management.Azure azure) {
        if (azure == null) {
            return;
        }
        Subscription subscription = azure.getCurrentSubscription();
        if (subscription != null) {
            Log.info((String)String.format(SUBSCRIPTION_TEMPLATE, TextUtils.cyan((String)subscription.displayName()), TextUtils.cyan((String)subscription.subscriptionId())));
        }
    }

    public Map<String, String> getTelemetryProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(INSTALLATION_ID_KEY, this.getInstallationId());
        map.put(PLUGIN_NAME_KEY, this.getPluginName());
        map.put(PLUGIN_VERSION_KEY, this.getPluginVersion());
        map.put(SUBSCRIPTION_ID_KEY, this.getSubscriptionId());
        map.put(SESSION_ID_KEY, this.getSessionId());
        return map;
    }

    public String getActualAuthType() {
        Account account = ((AzureAccount)Azure.az(AzureAccount.class)).account();
        if (account != null) {
            return account.getAuthType().toString();
        }
        return "Unknown";
    }

    public void execute() throws MojoExecutionException {
        try {
            AzureMessager.setDefaultMessager((IAzureMessager)new MavenAzureMessager());
            Azure.az().config().setLogLevel(HttpLogDetailLevel.NONE.name());
            Azure.az().config().setUserAgent(this.getUserAgent());
            ProxyUtils.initProxy(Optional.ofNullable(this.session).map(MavenSession::getRequest).orElse(null));
            this.initTelemetryProxy();
            this.telemetryProxy.addDefaultProperty(PROXY, String.valueOf(ProxyManager.getInstance().getProxy() != null));
            Thread.setDefaultUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler());
            Properties prop = new Properties();
            if (this.isFirstRun(prop)) {
                this.infoWithMultipleLines(PRIVACY_STATEMENT);
                this.updateConfigurationFile(prop);
            }
            if (this.isSkipMojo()) {
                Log.info((String)"Skip execution.");
                this.onSkipped();
            } else {
                this.beforeMojoExecution();
                this.doExecute();
                this.afterMojoExecution();
            }
        }
        catch (Exception e) {
            this.onMojoError(e);
        }
        finally {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
            ApacheSenderFactory.INSTANCE.create().close();
        }
    }

    protected boolean isSkipMojo() {
        return false;
    }

    protected abstract void doExecute() throws AzureExecutionException;

    protected void onSkipped() {
        this.telemetryProxy.trackEvent(((Object)((Object)this)).getClass().getSimpleName() + ".skip");
    }

    protected void beforeMojoExecution() {
        this.telemetryProxy.trackEvent(((Object)((Object)this)).getClass().getSimpleName() + ".start", this.getTelemetries(), null, false);
    }

    protected void afterMojoExecution() {
        this.telemetryProxy.trackEvent(((Object)((Object)this)).getClass().getSimpleName() + ".success", this.recordJvmUpTime(new HashMap<String, String>()));
    }

    protected void trackMojoFailure(Throwable throwable) {
        HashMap<String, String> failureParameters = new HashMap<String, String>();
        failureParameters.put(ERROR_MESSAGE, throwable.getMessage());
        failureParameters.put(ERROR_STACK, ExceptionUtils.getStackTrace((Throwable)throwable));
        failureParameters.put(ERROR_CLASSNAME, throwable.getClass().getName());
        this.telemetryProxy.trackEvent(((Object)((Object)this)).getClass().getSimpleName() + ".failure", this.recordJvmUpTime(failureParameters));
    }

    protected static String highlightDefaultValue(String defaultValue) {
        return StringUtils.isBlank((CharSequence)defaultValue) ? "" : String.format(" [%s]", TextUtils.blue((String)defaultValue));
    }

    protected void onMojoError(Exception exception) throws MojoExecutionException {
        String message;
        this.trackMojoFailure(exception);
        String string = message = StringUtils.isEmpty((CharSequence)exception.getMessage()) ? exception.toString() : exception.getMessage();
        if (this.isFailsOnError()) {
            throw new MojoExecutionException(message, exception);
        }
        Log.error((String)message);
    }

    protected void executeWithTimeRecorder(RunnableWithException operation, String name) throws AzureExecutionException {
        long startTime = System.currentTimeMillis();
        try {
            operation.run();
        }
        catch (Exception e) {
            try {
                throw new AzureExecutionException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                long endTime = System.currentTimeMillis();
                this.telemetryProxy.addDefaultProperty(String.format("%s-cost", name), String.valueOf(endTime - startTime));
                throw throwable;
            }
        }
        long endTime = System.currentTimeMillis();
        this.telemetryProxy.addDefaultProperty(String.format("%s-cost", name), String.valueOf(endTime - startTime));
    }

    private Map<String, String> recordJvmUpTime(Map<String, String> properties) {
        long jvmUpTime = ManagementFactory.getRuntimeMXBean().getUptime();
        properties.put(JVM_UP_TIME, String.valueOf(jvmUpTime));
        return properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isFirstRun(Properties prop) {
        try {
            File configurationFile = new File(CONFIGURATION_PATH);
            if (!configurationFile.exists()) {
                configurationFile.getParentFile().mkdirs();
                configurationFile.createNewFile();
                return true;
            }
            try (FileInputStream input = new FileInputStream(CONFIGURATION_PATH);){
                prop.load(input);
                String firstRunValue = prop.getProperty(FIRST_RUN_KEY);
                if (firstRunValue == null) return true;
                if (firstRunValue.isEmpty()) return true;
                if (!firstRunValue.equalsIgnoreCase("false")) return true;
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            Log.debug((String)e.getMessage());
        }
        return true;
    }

    private void updateConfigurationFile(Properties prop) {
        try (FileOutputStream output = new FileOutputStream(CONFIGURATION_PATH);){
            prop.setProperty(FIRST_RUN_KEY, "false");
            prop.store(output, "Azure Maven Plugin configurations");
        }
        catch (Exception e) {
            Log.debug((String)e.getMessage());
        }
    }

    public void infoWithMultipleLines(String messages) {
        String[] messageArray;
        for (String line : messageArray = messages.split("\\n")) {
            Log.info((String)line);
        }
    }

    protected String getTargetSubscriptionId(String defaultSubscriptionId, List<com.microsoft.azure.toolkit.lib.common.model.Subscription> subscriptions, List<com.microsoft.azure.toolkit.lib.common.model.Subscription> selectedSubscriptions) throws IOException, AzureExecutionException {
        String targetSubscriptionId = defaultSubscriptionId;
        if (StringUtils.isBlank((CharSequence)targetSubscriptionId) && selectedSubscriptions.size() == 1) {
            targetSubscriptionId = selectedSubscriptions.get(0).getId();
        }
        if (StringUtils.isBlank((CharSequence)targetSubscriptionId)) {
            return this.selectSubscription(subscriptions.toArray(new com.microsoft.azure.toolkit.lib.common.model.Subscription[0]));
        }
        this.telemetryProxy.addDefaultProperty(SUBSCRIPTION_ID_KEY, targetSubscriptionId);
        return targetSubscriptionId;
    }

    protected static void checkSubscription(List<com.microsoft.azure.toolkit.lib.common.model.Subscription> subscriptions, String targetSubscriptionId) throws AzureLoginException {
        if (StringUtils.isEmpty((CharSequence)targetSubscriptionId)) {
            return;
        }
        Optional<com.microsoft.azure.toolkit.lib.common.model.Subscription> optionalSubscription = subscriptions.stream().filter(subscription -> StringUtils.equals((CharSequence)subscription.getId(), (CharSequence)targetSubscriptionId)).findAny();
        if (!optionalSubscription.isPresent()) {
            throw new AzureLoginException(String.format(SUBSCRIPTION_NOT_FOUND, targetSubscriptionId));
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public MavenResourcesFiltering getMavenResourcesFiltering() {
        return this.mavenResourcesFiltering;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public boolean isAllowTelemetry() {
        return this.allowTelemetry;
    }

    public boolean isFailsOnError() {
        return this.failsOnError;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public AzureTelemetryClient getTelemetryProxy() {
        return this.telemetryProxy;
    }

    public Map<String, String> getTelemetries() {
        return this.telemetries;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    protected static interface RunnableWithException {
        public void run() throws Exception;
    }

    protected static class DefaultUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        protected DefaultUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            Log.debug((String)("uncaughtException: " + e));
        }
    }
}

