/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.utils;

import com.microsoft.azure.maven.utils.MavenUtils;
import com.microsoft.azure.maven.utils.XmlUtils;
import java.util.Collections;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.dom4j.Element;
import org.dom4j.dom.DOMElement;

public class MavenConfigUtils {
    private static final String POM = "pom";
    private static final String JAR = "jar";
    private static final String DEFAULT_DIRECTORY = "${project.basedir}/target";
    private static final String DEFAULT_INCLUDE = "*.jar";

    public static boolean isPomPackaging(MavenProject mavenProject) {
        return POM.equalsIgnoreCase(mavenProject.getPackaging());
    }

    public static boolean isJarPackaging(MavenProject mavenProject) {
        return JAR.equalsIgnoreCase(mavenProject.getPackaging());
    }

    public static void addResourcesConfig(Element root, List<Resource> resources) {
        DOMElement resourceRootNode = new DOMElement("resources");
        for (Resource resource : resources) {
            DOMElement resourceNode = new DOMElement("resource");
            XmlUtils.addDomWithKeyValue((Element)resourceNode, "filtering", resource.getFiltering());
            XmlUtils.addDomWithKeyValue((Element)resourceNode, "mergeId", resource.getMergeId());
            XmlUtils.addDomWithKeyValue((Element)resourceNode, "targetPath", resource.getTargetPath());
            XmlUtils.addDomWithKeyValue((Element)resourceNode, "directory", resource.getDirectory());
            XmlUtils.addDomWithValueList((Element)resourceNode, "includes", "include", resource.getIncludes());
            XmlUtils.addDomWithValueList((Element)resourceNode, "excludes", "exclude", resource.getExcludes());
            resourceRootNode.add((Element)resourceNode);
        }
        root.add((Element)resourceRootNode);
    }

    public static List<Resource> getDefaultResources() {
        Resource resource = new Resource();
        resource.setDirectory(DEFAULT_DIRECTORY);
        resource.addInclude(DEFAULT_INCLUDE);
        return Collections.singletonList(resource);
    }

    public static Xpp3Dom getPluginConfiguration(MavenProject proj, String pluginIdentifier) {
        return MavenUtils.getPluginConfiguration(proj, pluginIdentifier);
    }
}

