/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven;

import com.azure.core.management.AzureEnvironment;
import com.microsoft.azure.maven.AbstractAzureMojo;
import com.microsoft.azure.maven.model.DeploymentResource;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.auth.exception.AzureLoginException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.logging.Log;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import com.microsoft.azure.toolkit.lib.legacy.appservice.DeploymentSlotSetting;
import com.microsoft.azure.toolkit.lib.legacy.appservice.DeploymentType;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractAppServiceMojo
extends AbstractAzureMojo {
    protected static final String MAVEN_PLUGIN_POSTFIX = "-maven-plugin";
    protected static final String PORTAL_URL_PATTERN = "%s/#@/resource%s";
    @Parameter(property="resourceGroup", required=false)
    protected String resourceGroup;
    @Parameter(property="appName", required=false)
    protected String appName;
    @Parameter(property="deploymentType")
    protected String deploymentType;
    @Parameter(property="appServicePlanResourceGroup")
    protected String appServicePlanResourceGroup;
    @Parameter(property="appServicePlanName")
    protected String appServicePlanName;
    @Parameter(alias="deploymentSlot")
    protected DeploymentSlotSetting deploymentSlotSetting;
    @Parameter
    protected Properties appSettings;
    protected AzureAppService appServiceClient;

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppServicePlanResourceGroup() {
        return this.appServicePlanResourceGroup;
    }

    public String getAppServicePlanName() {
        return this.appServicePlanName;
    }

    public Map getAppSettings() {
        if (this.appSettings == null) {
            this.appSettings = new Properties();
        }
        return this.appSettings;
    }

    public DeploymentType getDeploymentType() throws AzureExecutionException {
        return DeploymentType.fromString((String)this.deploymentType);
    }

    public DeploymentSlotSetting getDeploymentSlotSetting() {
        return this.deploymentSlotSetting;
    }

    public List<DeploymentResource> getResources() {
        return Collections.EMPTY_LIST;
    }

    public String getDeploymentStagingDirectoryPath() {
        String outputFolder = this.getPluginName().replaceAll(MAVEN_PLUGIN_POSTFIX, "");
        return Paths.get(this.getBuildDirectoryAbsolutePath(), outputFolder, this.getAppName()).toString();
    }

    public void setDeploymentSlot(DeploymentSlotSetting slotSetting) {
        this.deploymentSlotSetting = slotSetting;
    }

    public String getResourcePortalUrl(String id) {
        AzureEnvironment environment = ((AzureAccount)Azure.az(AzureAccount.class)).account().getEnvironment();
        return String.format(PORTAL_URL_PATTERN, AbstractAppServiceMojo.getPortalUrl(environment), id);
    }

    protected static String getPortalUrl(AzureEnvironment azureEnvironment) {
        if (azureEnvironment == null || azureEnvironment == AzureEnvironment.AZURE) {
            return "https://ms.portal.azure.com";
        }
        if (azureEnvironment == AzureEnvironment.AZURE_CHINA) {
            return "https://portal.azure.cn";
        }
        return azureEnvironment.getPortal();
    }

    protected AzureAppService getOrCreateAzureAppServiceClient() {
        if (this.appServiceClient == null) {
            try {
                Account account = this.getAzureAccount();
                List subscriptions = account.getSubscriptions();
                String targetSubscriptionId = this.getTargetSubscriptionId(this.getSubscriptionId(), subscriptions, account.getSelectedSubscriptions());
                AbstractAppServiceMojo.checkSubscription(subscriptions, targetSubscriptionId);
                ((AzureAccount)Azure.az(AzureAccount.class)).account().selectSubscription(Collections.singletonList(targetSubscriptionId));
                this.appServiceClient = (AzureAppService)((AzureAppService)Azure.az(AzureAppService.class)).subscription(targetSubscriptionId);
                this.printCurrentSubscription(this.appServiceClient);
            }
            catch (AzureLoginException | AzureExecutionException | IOException e) {
                throw new AzureToolkitRuntimeException(String.format("Cannot authenticate due to error %s", e.getMessage()), e);
            }
        }
        return this.appServiceClient;
    }

    protected void printCurrentSubscription(AzureAppService appServiceClient) {
        if (appServiceClient == null) {
            return;
        }
        Subscription subscription = appServiceClient.getDefaultSubscription();
        if (subscription != null) {
            Log.info((String)String.format("Subscription: %s(%s)", TextUtils.cyan((String)subscription.getName()), TextUtils.cyan((String)subscription.getId())));
        }
    }
}

