/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.gradle.temeletry;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemeter;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemetryClient;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemetryConfigProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class TelemetryAgent {
    private static final String CONFIGURATION_PATH = Paths.get(System.getProperty("user.home"), ".azure", "gradleplugins.properties").toString();
    private static final String FIRST_RUN_KEY = "first.run";
    private static final String PRIVACY_STATEMENT = "\nData/Telemetry\n---------\nThis project collects usage data and sends it to Microsoft to help improve our products and services.\nRead Microsoft's privacy statement to learn more: https://privacy.microsoft.com/en-us/privacystatement.\n\nYou can change your telemetry configuration through 'allowTelemetry' property.\nFor more information, please go to https://aka.ms/azure-gradle-config.\n";
    private static final String ERROR_MESSAGE = "error.message";
    private static final String ERROR_STACK = "error.stack";
    private static final String ERROR_CLASSNAME = "error.class_name";
    private final AzureTelemetryClient telemetryProxy = AzureTelemeter.getClient();
    private static final TelemetryAgent instance = new TelemetryAgent();

    public static TelemetryAgent getInstance() {
        return instance;
    }

    @Deprecated
    public void addDefaultProperty(String key, String value) {
        AzureTelemeter.addCommonProperty((String)key, (String)value);
    }

    @Deprecated
    public void addDefaultProperties(Map<String, String> properties) {
        Optional.ofNullable(properties).ifPresent(values -> values.forEach(this::addDefaultProperty));
    }

    @Deprecated
    public void trackEvent(String event) {
        this.telemetryProxy.trackEvent(event);
    }

    @Deprecated
    public void trackEvent(String eventName, Map<String, String> customProperties) {
        this.telemetryProxy.trackEvent(eventName, customProperties);
    }

    public void showPrivacyStatement() {
        Properties prop = new Properties();
        if (this.isFirstRun(prop)) {
            AzureMessager.getMessager().confirm(PRIVACY_STATEMENT);
            this.updateConfigurationFile(prop);
        }
    }

    @Deprecated
    public void trackTaskSkip(@Nonnull Class<?> taskClass) {
        this.trackEvent(taskClass.getSimpleName() + ".skip");
    }

    @Deprecated
    public void trackTaskStart(@Nonnull Class<?> taskClass) {
        this.trackEvent(taskClass.getSimpleName() + ".start");
    }

    @Deprecated
    public void trackTaskSuccess(@Nonnull Class<?> taskClass) {
        this.trackEvent(taskClass.getSimpleName() + ".success");
    }

    @Deprecated
    public void traceException(@Nonnull Class<?> taskClass, Exception exception) {
        HashMap<String, String> failureReason = new HashMap<String, String>();
        String errorMessage = Optional.ofNullable(exception.getMessage()).filter(StringUtils::isNotEmpty).orElseGet(exception::toString);
        failureReason.put(ERROR_MESSAGE, errorMessage);
        failureReason.put(ERROR_STACK, ExceptionUtils.getStackTrace((Throwable)exception));
        failureReason.put(ERROR_CLASSNAME, exception.getClass().getName());
        this.trackEvent(taskClass.getSimpleName() + ".failure", failureReason);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isFirstRun(Properties prop) {
        try {
            File configurationFile = new File(CONFIGURATION_PATH);
            if (!configurationFile.exists()) {
                configurationFile.getParentFile().mkdirs();
                configurationFile.createNewFile();
                return true;
            }
            try (FileInputStream input = new FileInputStream(CONFIGURATION_PATH);){
                prop.load(input);
                String firstRunValue = prop.getProperty(FIRST_RUN_KEY);
                if (firstRunValue == null) return true;
                if (!firstRunValue.equalsIgnoreCase("false")) return true;
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            AzureMessager.getMessager().warning(e.getMessage());
        }
        return true;
    }

    private void updateConfigurationFile(Properties prop) {
        try (FileOutputStream output = new FileOutputStream(CONFIGURATION_PATH);){
            prop.setProperty(FIRST_RUN_KEY, "false");
            prop.store(output, "Azure Gradle Plugin configurations");
        }
        catch (Exception e) {
            AzureMessager.getMessager().warning(e.getMessage());
        }
    }

    public static class GradleAzureTelemetryCommonPropertiesProvider
    implements AzureTelemetryConfigProvider {
        public Map<String, String> getCommonProperties() {
            HashMap<String, String> map = new HashMap<String, String>();
            AzureConfiguration config = Azure.az().config();
            map.put("pluginName", config.getProduct());
            map.put("pluginVersion", config.getVersion());
            map.put("installationId", config.getMachineId());
            map.put("sessionId", config.getSessionId());
            return map;
        }

        public String getEventNamePrefix() {
            return "AzurePlugin.Gradle";
        }
    }
}

