/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.directconnectivity;

import com.microsoft.azure.documentdb.ConnectionPolicy;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.Error;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.ErrorUtils;
import com.microsoft.azure.documentdb.internal.OperationType;
import com.microsoft.azure.documentdb.internal.ResourceType;
import com.microsoft.azure.documentdb.internal.UserAgentContainer;
import com.microsoft.azure.documentdb.internal.Utils;
import com.microsoft.azure.documentdb.internal.directconnectivity.HttpClientFactory;
import com.microsoft.azure.documentdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.documentdb.internal.directconnectivity.TransportClient;
import java.io.IOException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTransportClient
extends TransportClient {
    private static final int HTTP_CLIENTS = Utils.getConcurrencyFactor();
    private final Logger logger = LoggerFactory.getLogger(HttpTransportClient.class);
    private static final UserAgentContainer defaultUserAgentContainer = new UserAgentContainer();
    private HttpClient[] httpClient;
    private HttpHost proxy;
    private boolean handleServiceUnavailableFromProxy;
    private final UserAgentContainer requestUserAgentContainer;

    public HttpTransportClient(HttpClient[] httpClients, ConnectionPolicy connectionPolicy, UserAgentContainer userAgentContainer) {
        this.httpClient = httpClients;
        this.proxy = connectionPolicy.getProxy();
        this.handleServiceUnavailableFromProxy = connectionPolicy.getHandleServiceUnavailableFromProxy();
        this.requestUserAgentContainer = userAgentContainer == null ? defaultUserAgentContainer : userAgentContainer;
    }

    public HttpTransportClient(ConnectionPolicy connectionPolicy, UserAgentContainer userAgentContainer) {
        this(HttpTransportClient.createHttpClients(connectionPolicy), connectionPolicy, userAgentContainer);
    }

    private static HttpClient[] createHttpClients(ConnectionPolicy connectionPolicy) {
        HttpClient[] httpClients = new HttpClient[HTTP_CLIENTS];
        for (int i = 0; i < httpClients.length; ++i) {
            PoolingHttpClientConnectionManager connectionManager = HttpClientFactory.createConnectionManager(connectionPolicy.getMaxPoolSize(), connectionPolicy.getIdleConnectionTimeout(), connectionPolicy.getDirectRequestTimeout());
            httpClients[i] = HttpClientFactory.createHttpClient((HttpClientConnectionManager)connectionManager, connectionPolicy.getDirectRequestTimeout());
        }
        return httpClients;
    }

    private static void addHeader(HttpRequestBase httpRequest, String headerName, DocumentServiceRequest request) {
        String headerValue = request.getHeaders().get(headerName);
        HttpTransportClient.addHeader(httpRequest, headerName, headerValue);
    }

    private static void addHeader(HttpRequestBase httpRequest, String headerName, String headerValue) {
        if (!StringUtils.isEmpty((CharSequence)headerValue)) {
            httpRequest.addHeader(headerName, headerValue);
        }
    }

    private static String GetDateHeader(Map<String, String> headers) {
        if (headers == null) {
            return "";
        }
        String date = headers.get("x-ms-date");
        if (StringUtils.isEmpty((CharSequence)date)) {
            date = headers.get("date");
        }
        return date != null ? date : "";
    }

    private void setDefaultHeaders(HttpRequestBase httpRequest) {
        HttpTransportClient.addHeader(httpRequest, "x-ms-version", "2018-09-17");
        HttpTransportClient.addHeader(httpRequest, "User-Agent", this.requestUserAgentContainer.getUserAgent());
        HttpTransportClient.addHeader(httpRequest, "Accept", "application/json");
        HttpTransportClient.addHeader(httpRequest, "Cache-Control", "no-cache");
    }

    public HttpClient getHttpClient(URI physicalAddress) {
        return this.httpClient[Math.abs(physicalAddress.hashCode() % this.httpClient.length)];
    }

    public StoreResponse invokeStore(URI physicalAddress, HttpRequestBase httpRequest, boolean isMedia, String activityId, boolean isReadOnlyRequest) throws DocumentClientException {
        try {
            this.logger.trace("Sending request {}", (Object)physicalAddress);
            HttpResponse response = this.getHttpClient(physicalAddress).execute((HttpUriRequest)httpRequest, (HttpContext)HttpClientContext.create());
            StoreResponse storeResponse = this.processResponse(physicalAddress.getPath(), isMedia, response, activityId);
            return storeResponse;
        }
        catch (IOException e) {
            if (isReadOnlyRequest) {
                this.logger.debug("Received exception {} on read only request, sending request to {}, will re-resolve the address", (Object)e.getMessage(), (Object)physicalAddress);
                throw new DocumentClientException(410, e);
            }
            if (e instanceof NoHttpResponseException || e instanceof UnknownHostException || e instanceof HttpHostConnectException || e instanceof ConnectTimeoutException || e instanceof SocketException && e.getMessage().contains("Connection reset")) {
                this.logger.debug("Received retrieable exception {}, sending request to {}, will re-resolve the address", (Object)e.getMessage(), (Object)physicalAddress);
                throw new DocumentClientException(410, e);
            }
            throw new DocumentClientException(503, e, Collections.singletonMap("x-ms-write-request-trigger-refresh", "1"));
        }
        catch (DocumentClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            httpRequest.releaseConnection();
        }
    }

    @Override
    public StoreResponse invokeStore(URI physicalAddress, DocumentServiceRequest request) throws DocumentClientException {
        HttpRequestBase httpRequest = this.prepareHttpMessage(request.getActivityId(), physicalAddress, request.getOperationType(), request.getResourceType(), request);
        return this.invokeStore(physicalAddress, httpRequest, request.getIsMedia(), request.getActivityId(), request.isReadOnlyRequest());
    }

    private StoreResponse processResponse(String requestUri, boolean isMedia, HttpResponse response, String activityId) throws DocumentClientException {
        if (requestUri == null) {
            throw new IllegalArgumentException("requestUri");
        }
        if (response == null) {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-ms-activity-id", activityId);
            headers.put("x-ms-request-validation-failure", "1");
            String errorBodyTemplate = "{'code':'%d', 'message':'Message: {\"Errors\":[\"%s\"]}'}";
            String errorBody = String.format(errorBodyTemplate, 500, "The backend response was not in the correct format.");
            throw new DocumentClientException(500, new Error(errorBody), headers);
        }
        if (this.handleServiceUnavailableFromProxy && response.getStatusLine().getStatusCode() == 503 && response.getHeaders("x-ms-serviceversion") == null) {
            this.logger.debug("Received retriable exception: Service Unavailable from proxy server is missing x-ms-serviceversion header, indicating connectivity issues. Handling as GONE exception. Will re-resolve the address and retry.");
            throw new DocumentClientException(410, new Exception());
        }
        if (response.getStatusLine().getStatusCode() < 300 || response.getStatusLine().getStatusCode() == 304) {
            return StoreResponse.fromHttpResponse(response, isMedia, null);
        }
        ErrorUtils.maybeThrowException(requestUri, response, false, this.logger);
        return null;
    }

    public HttpRequestBase prepareHttpMessage(String activityId, URI physicalAddress, OperationType operationType, ResourceType resourceType, DocumentServiceRequest request) {
        HttpDelete httpRequest;
        URI resourceUri = null;
        try {
            resourceUri = new URI(physicalAddress.getScheme(), physicalAddress.getUserInfo(), physicalAddress.getHost(), physicalAddress.getPort(), physicalAddress.getPath() + Utils.trimBeginingAndEndingSlashes(request.getPath()), physicalAddress.getQuery(), physicalAddress.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        switch (operationType) {
            case Create: 
            case Upsert: 
            case ExecuteJavaScript: {
                HttpPost postRequest = new HttpPost(resourceUri);
                postRequest.setEntity(request.getBody());
                httpRequest = postRequest;
                break;
            }
            case Replace: {
                HttpPut putRequest = new HttpPut(resourceUri);
                putRequest.setEntity(request.getBody());
                httpRequest = putRequest;
                break;
            }
            case Delete: {
                HttpDelete deleteRequest;
                httpRequest = deleteRequest = new HttpDelete(resourceUri);
                break;
            }
            case Read: 
            case ReadFeed: {
                HttpGet getRequest = new HttpGet(resourceUri);
                httpRequest = getRequest;
                break;
            }
            case Query: 
            case SqlQuery: {
                HttpPost queryPostRequest = new HttpPost(resourceUri);
                httpRequest = queryPostRequest;
                queryPostRequest.setEntity(request.getBody());
                HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "Content-Type", "application/query+json");
                HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-documentdb-isquery", Boolean.TRUE.toString());
                break;
            }
            case Head: 
            case HeadFeed: {
                HttpHead headRequest = new HttpHead(resourceUri);
                httpRequest = headRequest;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid operation type");
            }
        }
        this.setDefaultHeaders((HttpRequestBase)httpRequest);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-documentdb-responsecontinuationtokenlimitinkb", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-version", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "User-Agent", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-max-item-count", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-documentdb-pre-trigger-include", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-documentdb-pre-trigger-exclude", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-documentdb-post-trigger-include", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-documentdb-post-trigger-exclude", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "authorization", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-indexing-directive", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-consistency-level", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-session-token", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "Prefer", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-documentdb-expiry-seconds", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-documentdb-query-enable-scan", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-documentdb-query-emit-traces", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-continuation", request.getContinuation());
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-activity-id", activityId);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-documentdb-partitionkey", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-documentdb-partitionkeyrangeid", request);
        String dateHeader = HttpTransportClient.GetDateHeader(request.getHeaders());
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-date", dateHeader);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "Match", this.GetMatch(request, request.getOperationType()));
        String fanoutRequestHeader = request.getHeaders().get("x-ms-is-fanout-request");
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-is-fanout-request", fanoutRequestHeader);
        if (!request.getIsNameBased()) {
            HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-docdb-resource-id", request.getResourceId());
        }
        if (request.getResourceType() == ResourceType.DocumentCollection) {
            HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "collection-partition-index", request.getHeaders().get("collection-partition-index"));
            HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "collection-service-index", request.getHeaders().get("collection-service-index"));
        }
        if (request.getHeaders().get("x-ms-bind-replica") != null) {
            HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-bind-replica", request.getHeaders().get("x-ms-bind-replica"));
            HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-primary-master-key", request.getHeaders().get("x-ms-primary-master-key"));
            HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-secondary-master-key", request.getHeaders().get("x-ms-secondary-master-key"));
            HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-primary-readonly-key", request.getHeaders().get("x-ms-primary-readonly-key"));
            HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-secondary-readonly-key", request.getHeaders().get("x-ms-secondary-readonly-key"));
            HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-documentdb-bindmineffectivepartitionkey", request.getHeaders().get("x-ms-documentdb-bindmineffectivepartitionkey"));
            HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-documentdb-bindmaxeffectivepartitionkey", request.getHeaders().get("x-ms-documentdb-bindmaxeffectivepartitionkey"));
            HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-documentdb-bindpartitionkeyrangeid", request.getHeaders().get("x-ms-documentdb-bindpartitionkeyrangeid"));
            HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-documentdb-bindpartitionkeyrangeridprefix", request.getHeaders().get("x-ms-documentdb-bindpartitionkeyrangeridprefix"));
            HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-documentdb-minimumallowedclientversion", request.getHeaders().get("x-ms-documentdb-minimumallowedclientversion"));
        }
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-documentdb-is-upsert", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-cosmos-allow-tentative-writes", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-documentdb-partitioncount", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-documentdb-collection-rid", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-documentdb-script-enable-logging", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-documentdb-populatequotainfo", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-documentdb-disable-ru-per-minute-usage", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "A-IM", request);
        HttpTransportClient.addHeader((HttpRequestBase)httpRequest, "x-ms-exclude-system-properties", request);
        if (this.proxy != null) {
            RequestConfig requestConfig = RequestConfig.custom().setProxy(this.proxy).build();
            httpRequest.setConfig(requestConfig);
        }
        httpRequest.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        return httpRequest;
    }

    private String GetMatch(DocumentServiceRequest request, OperationType resourceOperation) {
        switch (resourceOperation) {
            case Upsert: 
            case ExecuteJavaScript: 
            case Replace: 
            case Delete: 
            case Update: {
                return request.getHeaders().get("If-Match");
            }
            case Read: 
            case ReadFeed: {
                return request.getHeaders().get("If-None-Match");
            }
        }
        return null;
    }
}

