/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.directconnectivity;

import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.internal.BridgeInternal;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoneAndRetryWithRetryPolicy
implements RetryPolicy {
    private static final int WAIT_TIME_IN_SECONDS = 30;
    private static final int INITIALI_BACKOFF_SEONDS = 1;
    private static final int BACKOFF_MULTIPLIER = 2;
    private final Logger LOGGER = LoggerFactory.getLogger(GoneAndRetryWithRetryPolicy.class);
    private int attemptCount = 1;
    private DocumentClientException lastRetryWithException;
    private int currentBackOffSeconds = 1;
    private DocumentServiceRequest request;
    private long startTimeMilliSeconds;
    private long retryAfterSeconds;
    private boolean retryPartitionKeyRangeIdentity = true;

    public GoneAndRetryWithRetryPolicy(DocumentServiceRequest request) {
        this.request = request;
        this.startTimeMilliSeconds = System.currentTimeMillis();
    }

    @Override
    public boolean shouldRetry(DocumentClientException exception) throws DocumentClientException {
        if (exception.getStatusCode() != 410 && exception.getStatusCode() != 449) {
            return false;
        }
        Integer substatusCode = exception.getSubStatusCode();
        if (substatusCode != null && substatusCode == 1002 && BridgeInternal.isUserProvidedPartitionKeyRangeIdentity(this.request)) {
            if (this.retryPartitionKeyRangeIdentity) {
                this.request.setForcePartitionKeyRangeRefresh(true);
                this.retryPartitionKeyRangeIdentity = false;
            } else {
                this.LOGGER.warn("Received invalid partition id from user, retry won't happen, failing the request", (Throwable)exception);
                return false;
            }
        }
        if (exception.getStatusCode() == 449) {
            this.lastRetryWithException = exception;
        }
        this.retryAfterSeconds = 0L;
        long remainingSeconds = 30 - (int)((double)(System.currentTimeMillis() - this.startTimeMilliSeconds) * 1.0 / 1000.0);
        if (this.attemptCount++ > 1) {
            if (remainingSeconds <= 0L) {
                if (exception.getStatusCode() == 410) {
                    String exceptionName;
                    String string = exceptionName = substatusCode != null && substatusCode == 1000 ? "invalid partition exception" : "gone exception";
                    if (this.lastRetryWithException != null) {
                        this.LOGGER.warn("Received {} after backoff/retry including at least one RetryWithException. Will fail the request with RetryWithException", (Object)exceptionName, (Object)this.lastRetryWithException);
                        throw this.lastRetryWithException;
                    }
                    this.LOGGER.warn("Received {} after backoff/retry. Will fail the request", (Object)exceptionName, (Object)exception);
                    throw new DocumentClientException(503, exception);
                }
                this.LOGGER.warn("Received retryWith exception after backoff/retry. Will fail the request", (Throwable)exception);
                return false;
            }
            this.retryAfterSeconds = Math.min((long)this.currentBackOffSeconds, remainingSeconds);
            this.currentBackOffSeconds *= 2;
        }
        if (exception.getStatusCode() == 410) {
            if (substatusCode != null && substatusCode == 1000) {
                this.request.setQuorumSelectedLSN(-1L);
                this.request.setQuorumSelectedStoreResponse(null);
                this.request.setForceNameCacheRefresh(true);
                this.LOGGER.debug("Received Gone exception with sub status name_cach_ is_stale " + substatusCode + ", will retry with name cache refresh");
            } else if (substatusCode != null && (substatusCode == 1007 || substatusCode == 1008 || substatusCode == 1002)) {
                this.request.setForcePartitionKeyRangeRefresh(true);
                this.LOGGER.debug("Received Gone exception with sub status " + substatusCode + ", will retry with partition key range cache refresh");
            }
            this.request.setForceAddressRefresh(true);
            this.LOGGER.debug("Received Gone exception, will retry with address cache refresh");
        } else {
            this.LOGGER.debug("Received retryWith exception, will retry", (Throwable)exception);
        }
        return true;
    }

    @Override
    public long getRetryAfterInMilliseconds() {
        return this.retryAfterSeconds * 1000L;
    }
}

