/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.routing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.PartitionKeyDefinition;
import com.microsoft.azure.documentdb.PartitionKeyRange;
import com.microsoft.azure.documentdb.SqlQuerySpec;
import com.microsoft.azure.documentdb.internal.Utils;
import com.microsoft.azure.documentdb.internal.query.PartitionedQueryExecutionInfo;
import com.microsoft.azure.documentdb.internal.query.QueryPartitionProvider;
import com.microsoft.azure.documentdb.internal.routing.CompositeContinuationToken;
import com.microsoft.azure.documentdb.internal.routing.PartitionKeyInternal;
import com.microsoft.azure.documentdb.internal.routing.Range;
import com.microsoft.azure.documentdb.internal.routing.RoutingMapProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionRoutingHelper {
    private static final Logger logger = LoggerFactory.getLogger(PartitionRoutingHelper.class);

    public static PartitionKeyRange tryGetTargetRangeFromContinuationTokenRange(List<Range<String>> providedPartitionKeyRanges, RoutingMapProvider routingMapProvider, String collectionLink, Range<String> rangeFromContinuationToken) {
        if (providedPartitionKeyRanges.size() == 0) {
            return routingMapProvider.tryGetRangeByEffectivePartitionKey(collectionLink, PartitionKeyInternal.MinimumInclusiveEffectivePartitionKey);
        }
        if (rangeFromContinuationToken.isEmpty()) {
            Range<String> minimumRange = PartitionRoutingHelper.min(providedPartitionKeyRanges, new Range.MinComparator());
            return routingMapProvider.tryGetRangeByEffectivePartitionKey(collectionLink, minimumRange.getMin());
        }
        PartitionKeyRange targetPartitionKeyRange = routingMapProvider.tryGetRangeByEffectivePartitionKey(collectionLink, rangeFromContinuationToken.getMin());
        if (targetPartitionKeyRange == null || !rangeFromContinuationToken.equals(targetPartitionKeyRange.toRange())) {
            return null;
        }
        return targetPartitionKeyRange;
    }

    private static <T> T min(List<T> values, Comparator<T> comparer) {
        if (values.size() == 0) {
            throw new IllegalArgumentException("values");
        }
        T min = values.get(0);
        for (int i = 1; i < values.size(); ++i) {
            if (comparer.compare(values.get(i), min) >= 0) continue;
            min = values.get(i);
        }
        return min;
    }

    public static Range<String> extractPartitionKeyRangeFromContinuationToken(Map<String, String> headers) {
        Range<String> range = Range.getEmptyRange(PartitionKeyInternal.MinimumInclusiveEffectivePartitionKey);
        String continuationToken = headers.get("x-ms-continuation");
        if (continuationToken == null || continuationToken.isEmpty()) {
            return range;
        }
        try {
            CompositeContinuationToken compositeContinuationToken = (CompositeContinuationToken)Utils.getSimpleObjectMapper().readValue(continuationToken, CompositeContinuationToken.class);
            if (compositeContinuationToken.getRange() != null) {
                range = compositeContinuationToken.getRange();
            }
            headers.put("x-ms-continuation", compositeContinuationToken.getToken() != null && !compositeContinuationToken.getToken().isEmpty() ? compositeContinuationToken.getToken() : "");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return range;
    }

    public static boolean tryAddPartitionKeyRangeToContinuationToken(Map<String, String> headers, List<Range<String>> providedPartitionKeyRanges, RoutingMapProvider routingMapProvider, String collectionLink, PartitionKeyRange currentRange) {
        PartitionKeyRange rangeToUse = currentRange;
        if (headers.get("x-ms-continuation") == null || headers.get("x-ms-continuation").isEmpty()) {
            String max;
            Range<String> nextProvidedRange = PartitionRoutingHelper.minAfter(providedPartitionKeyRanges, currentRange.toRange(), new Range.MaxComparator());
            if (nextProvidedRange == null) {
                return true;
            }
            String string = max = nextProvidedRange.getMin().compareTo(currentRange.getMaxExclusive()) > 0 ? nextProvidedRange.getMin() : currentRange.getMaxExclusive();
            if (max.compareTo(PartitionKeyInternal.MaximumExclusiveEffectivePartitionKey) == 0) {
                return true;
            }
            PartitionKeyRange nextRange = routingMapProvider.tryGetRangeByEffectivePartitionKey(collectionLink, max);
            if (nextRange == null) {
                return false;
            }
            rangeToUse = nextRange;
        }
        if (rangeToUse != null) {
            headers.put("x-ms-continuation", PartitionRoutingHelper.addPartitionKeyRangeToContinuationToken(headers.get("x-ms-continuation"), rangeToUse));
        }
        return true;
    }

    private static <T> T minAfter(List<T> values, T minValue, Comparator<T> comparer) {
        if (values.size() == 0) {
            throw new IllegalArgumentException("values");
        }
        Object min = null;
        for (T value : values) {
            if (comparer.compare(value, minValue) <= 0 || min != null && comparer.compare(value, min) >= 0) continue;
            min = value;
        }
        return min;
    }

    private static String addPartitionKeyRangeToContinuationToken(String continuationToken, PartitionKeyRange partitionKeyRange) {
        CompositeContinuationToken compositeContinuationToken = new CompositeContinuationToken();
        compositeContinuationToken.setToken(continuationToken);
        compositeContinuationToken.setRange(partitionKeyRange.toRange());
        try {
            String serializedCompositeToken = Utils.getSimpleObjectMapper().writeValueAsString((Object)compositeContinuationToken);
            return serializedCompositeToken;
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static List<Range<String>> getProvidedPartitionKeyRanges(SqlQuerySpec querySpec, boolean enableCrossPartitionQuery, boolean parallelizeCrossPartitionQuery, PartitionKeyDefinition partitionKeyDefinition, QueryPartitionProvider queryPartitionProvider, String clientApiVersion) throws DocumentClientException {
        if (querySpec == null) {
            throw new IllegalArgumentException("querySpec");
        }
        if (queryPartitionProvider == null) {
            throw new IllegalArgumentException("queryPartitionProvider");
        }
        if (partitionKeyDefinition != null && partitionKeyDefinition.getPaths().size() > 0) {
            boolean isSinglePartitionQuery;
            PartitionedQueryExecutionInfo queryExecutionInfo = null;
            queryExecutionInfo = queryPartitionProvider.getPartitionQueryExcecutionInfo(querySpec, partitionKeyDefinition);
            if (queryExecutionInfo == null || queryExecutionInfo.getQueryRanges() == null || queryExecutionInfo.getQueryInfo() == null) {
                logger.debug("QueryPartitionProvider");
            }
            boolean bl = isSinglePartitionQuery = queryExecutionInfo.getQueryRanges().size() == 1 && queryExecutionInfo.getQueryRanges().iterator().next().isSingleValue();
            if (!isSinglePartitionQuery) {
                if (!enableCrossPartitionQuery) {
                    throw new DocumentClientException(400, "Cross partition query is required but disabled. Please set x-ms-documentdb-query-enablecrosspartition to true, specify x-ms-documentdb-partitionkey, or revise your query to avoid this exception.");
                }
                if (parallelizeCrossPartitionQuery || queryExecutionInfo.getQueryInfo() != null && (queryExecutionInfo.getQueryInfo().hasTop() || queryExecutionInfo.getQueryInfo().hasOrderBy() || queryExecutionInfo.getQueryInfo().hasAggregates())) {
                    throw new DocumentClientException(400, "Cross partition query with TOP and/or ORDER BY is not supported. " + queryExecutionInfo.toJson());
                }
            }
            return queryExecutionInfo.getQueryRanges();
        }
        return new ArrayList<Range<String>>(){
            {
                this.add(Range.getPointRange(PartitionKeyInternal.MinimumInclusiveEffectivePartitionKey));
            }
        };
    }
}

