/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.routing;

import com.microsoft.azure.documentdb.DocumentQueryClientInternal;
import com.microsoft.azure.documentdb.PartitionKeyRange;
import com.microsoft.azure.documentdb.internal.AsyncCache;
import com.microsoft.azure.documentdb.internal.PathInfo;
import com.microsoft.azure.documentdb.internal.PathsHelper;
import com.microsoft.azure.documentdb.internal.ResourceType;
import com.microsoft.azure.documentdb.internal.routing.CollectionRoutingMap;
import com.microsoft.azure.documentdb.internal.routing.InMemoryCollectionRoutingMap;
import com.microsoft.azure.documentdb.internal.routing.Range;
import com.microsoft.azure.documentdb.internal.routing.RoutingMapProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.tuple.ImmutablePair;

public final class PartitionKeyRangeCache
implements RoutingMapProvider {
    private final DocumentQueryClientInternal client;
    private final AsyncCache<String, CollectionRoutingMap> routingMapCache;

    public PartitionKeyRangeCache(DocumentQueryClientInternal client) {
        this.client = client;
        this.routingMapCache = new AsyncCache(client.getExecutorService());
    }

    @Override
    public Collection<PartitionKeyRange> getOverlappingRanges(final String collectionIdOrNameBasedLink, Range<String> range) {
        CollectionRoutingMap routingMap;
        try {
            routingMap = this.routingMapCache.get(collectionIdOrNameBasedLink, null, new Callable<CollectionRoutingMap>(){

                @Override
                public CollectionRoutingMap call() throws Exception {
                    return PartitionKeyRangeCache.this.getRoutingMapForCollection(collectionIdOrNameBasedLink);
                }
            }).get();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return routingMap.getOverlappingRanges(range);
    }

    @Override
    public PartitionKeyRange tryGetRangeByEffectivePartitionKey(String collectionRid, String effectivePartitionKey) {
        Collection<PartitionKeyRange> ranges = this.getOverlappingRanges(collectionRid, Range.getPointRange(effectivePartitionKey));
        if (ranges == null) {
            return null;
        }
        return ranges.iterator().next();
    }

    private CollectionRoutingMap getRoutingMapForCollection(String collectionAddress) {
        PathInfo pathInfo = PathsHelper.parsePathSegments(collectionAddress);
        if (pathInfo == null) {
            throw new IllegalArgumentException(String.format("Unable to parse path %s", collectionAddress));
        }
        String collectionLink = pathInfo.isFeed ? (pathInfo.isNameBased ? pathInfo.resourceIdOrFullName : PathsHelper.generatePath(ResourceType.DocumentCollection, pathInfo.resourceIdOrFullName, false)) : collectionAddress;
        ArrayList ranges = new ArrayList();
        for (PartitionKeyRange range : this.client.readPartitionKeyRanges(collectionLink, null).getQueryIterable()) {
            ranges.add(new ImmutablePair((Object)range, (Object)true));
        }
        InMemoryCollectionRoutingMap routingMap = InMemoryCollectionRoutingMap.tryCreateCompleteRoutingMap(ranges, "");
        if (routingMap == null) {
            throw new IllegalStateException("Cannot create complete routing map");
        }
        return routingMap;
    }
}

