/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.query;

import com.microsoft.azure.documentdb.PartitionKeyDefinition;
import com.microsoft.azure.documentdb.SqlQuerySpec;
import com.microsoft.azure.documentdb.internal.ServiceJNIWrapper;
import com.microsoft.azure.documentdb.internal.query.PartitionedQueryExecutionInfo;
import com.microsoft.azure.documentdb.internal.query.PartitionedQueryExecutionInfoInternal;
import com.microsoft.azure.documentdb.internal.query.QueryInfo;
import com.microsoft.azure.documentdb.internal.routing.PartitionKeyInternal;
import com.microsoft.azure.documentdb.internal.routing.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class QueryPartitionProvider {
    private static final List<Range<String>> singleFullRange = new ArrayList<Range<String>>(){
        {
            this.add(new Range<String>(PartitionKeyInternal.MinimumInclusiveEffectivePartitionKey, PartitionKeyInternal.MaximumExclusiveEffectivePartitionKey, true, false));
        }
    };
    private String queryEngineConfiguration;
    private volatile long serviceProvider = 0L;

    public QueryPartitionProvider(String queryEngineConfiguration) {
        this.queryEngineConfiguration = queryEngineConfiguration;
    }

    public PartitionedQueryExecutionInfo getPartitionQueryExcecutionInfo(SqlQuerySpec querySpec, PartitionKeyDefinition partitionKeyDefinition) {
        if (querySpec == null || partitionKeyDefinition == null || partitionKeyDefinition.getPaths().size() == 0) {
            return new PartitionedQueryExecutionInfo(new QueryInfo(), singleFullRange);
        }
        this.initializeServiceProvider();
        PartitionedQueryExecutionInfoInternal partitionedQueryExecutionInfoInternal = ServiceJNIWrapper.getPartitionKeyRangesFromQuery(this.serviceProvider, querySpec, partitionKeyDefinition);
        ArrayList<Range<String>> effectiveRanges = new ArrayList<Range<String>>(partitionedQueryExecutionInfoInternal.getQueryRanges().size());
        for (Range<PartitionKeyInternal> internalRange : partitionedQueryExecutionInfoInternal.getQueryRanges()) {
            effectiveRanges.add(new Range<String>(internalRange.getMin().getEffectivePartitionKeyString(partitionKeyDefinition, false), internalRange.getMax().getEffectivePartitionKeyString(partitionKeyDefinition, false), internalRange.isMinInclusive(), internalRange.isMaxInclusive()));
        }
        Collections.sort(effectiveRanges, new Range.MinComparator());
        return new PartitionedQueryExecutionInfo(partitionedQueryExecutionInfoInternal.getQueryInfo(), effectiveRanges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeServiceProvider() {
        if (this.serviceProvider == 0L) {
            QueryPartitionProvider queryPartitionProvider = this;
            synchronized (queryPartitionProvider) {
                if (this.serviceProvider == 0L) {
                    this.serviceProvider = ServiceJNIWrapper.createServiceProvider(this.queryEngineConfiguration);
                }
            }
        }
    }
}

