/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.query;

import com.microsoft.azure.documentdb.Document;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.PartitionKeyRange;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.DocumentServiceResponse;
import com.microsoft.azure.documentdb.internal.query.ParallelQueryExecutionContext;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DocumentProducer
implements Iterator<Document> {
    private final LinkedBlockingQueue<Document> documentBuffer = new LinkedBlockingQueue();
    private final ParallelQueryExecutionContext parentQueryExecutionContext;
    private final DocumentServiceRequest request;
    private final PartitionKeyRange targetRange;
    private final Class<? extends Document> deserializationClass;
    private Document currentDocument;
    private boolean hasStarted;
    private int previousResponseItemCount;
    private Map<String, String> previousResponseHeaders;
    private static final Document STOP_MARKER = new Document();
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentProducer.class);

    public DocumentProducer(ParallelQueryExecutionContext parentQueryExecutionContext, DocumentServiceRequest request, PartitionKeyRange targetRange, Class<? extends Document> deserializationClass) {
        this.parentQueryExecutionContext = parentQueryExecutionContext;
        this.request = request;
        this.targetRange = targetRange;
        this.deserializationClass = deserializationClass;
        this.currentDocument = null;
        this.hasStarted = false;
        this.request.getHeaders().put("x-ms-documentdb-partitionkeyrangeid", this.targetRange.getId());
    }

    @Override
    public boolean hasNext() {
        return !this.isFinished() || this.currentDocument != null || !this.documentBuffer.isEmpty();
    }

    @Override
    public Document next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("next");
        }
        DocumentProducer documentProducer = this;
        synchronized (documentProducer) {
            try {
                if (this.currentDocument == null) {
                    this.currentDocument = this.documentBuffer.take();
                    if (this.currentDocument == STOP_MARKER) {
                        throw new IllegalStateException("Query execution has been stopped.");
                    }
                }
                Document result = this.currentDocument;
                this.currentDocument = null;
                return result;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Failed to take Document from buffer", e);
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public boolean hasStarted() {
        return this.hasStarted;
    }

    public String getId() {
        return this.targetRange.getId();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DocumentProducer)) {
            return false;
        }
        return this.getId().compareTo(((DocumentProducer)obj).getId()) == 0;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean isFinished() {
        return this.hasStarted && StringUtils.isEmpty((CharSequence)this.request.getHeaders().get("x-ms-continuation"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document peek() {
        if (!this.hasNext()) {
            throw new IllegalStateException("peek should not be called when hasNext is false");
        }
        DocumentProducer documentProducer = this;
        synchronized (documentProducer) {
            if (this.currentDocument == null) {
                try {
                    this.currentDocument = this.documentBuffer.take();
                    if (this.currentDocument == STOP_MARKER) {
                        throw new IllegalStateException("Query execution has been stopped.");
                    }
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("Failed to peek Document from buffer", e);
                }
            }
            return this.currentDocument;
        }
    }

    public int size() {
        return this.documentBuffer.size();
    }

    public int getPreviousResponseItemCount() {
        return this.previousResponseItemCount;
    }

    public Map<String, String> getPreviousResponseHeaders() {
        return this.previousResponseHeaders;
    }

    public PartitionKeyRange getTargetRange() {
        return this.targetRange;
    }

    public DocumentProducer produce() throws DocumentClientException {
        if (this.isFinished()) {
            throw new IllegalStateException("produce should not be called when it is finished.");
        }
        DocumentServiceResponse response = null;
        try {
            response = this.parentQueryExecutionContext.executeRequest(this.request);
        }
        catch (DocumentClientException e) {
            LOGGER.error("Failed to execute request", (Throwable)e);
            this.hasStarted = true;
            this.request.getHeaders().remove("x-ms-continuation");
            throw e;
        }
        List<? extends Document> items = response.getQueryResponse(this.deserializationClass);
        this.previousResponseItemCount = items.size();
        LOGGER.trace("Producer with range Id {} fetched {} items", (Object)this.targetRange.getId(), (Object)items.size());
        this.documentBuffer.addAll(items);
        this.previousResponseHeaders = response.getResponseHeaders();
        this.request.getHeaders().put("x-ms-continuation", response.getResponseHeaders().get("x-ms-continuation"));
        this.hasStarted = true;
        return this;
    }

    void notifyStop() {
        this.request.getHeaders().remove("x-ms-continuation");
        this.currentDocument = null;
        this.documentBuffer.clear();
        this.documentBuffer.add(STOP_MARKER);
    }
}

